/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import org.jrobin.graph.ImageParameters;
import org.jrobin.graph.RrdGraph;
import org.jrobin.graph.RrdGraphDef;

class Mapper {
    private RrdGraphDef gdef;
    private ImageParameters im;
    private double pixieX;
    private double pixieY;

    Mapper(RrdGraph rrdGraph) {
        this(rrdGraph.gdef, rrdGraph.im);
    }

    Mapper(RrdGraphDef gdef, ImageParameters im) {
        this.gdef = gdef;
        this.im = im;
        this.pixieX = (double)im.xsize / (double)(im.end - im.start);
        this.pixieY = !gdef.logarithmic ? (double)im.ysize / (im.maxval - im.minval) : (double)im.ysize / (Math.log10(im.maxval) - Math.log10(im.minval));
    }

    int xtr(double mytime) {
        return (int)((double)this.im.xorigin + this.pixieX * (mytime - (double)this.im.start));
    }

    int ytr(double value) {
        double yval = !this.gdef.logarithmic ? (double)this.im.yorigin - this.pixieY * (value - this.im.minval) + 0.5 : (value < this.im.minval ? (double)this.im.yorigin : (double)this.im.yorigin - this.pixieY * (Math.log10(value) - Math.log10(this.im.minval)) + 0.5);
        if (!this.gdef.rigid) {
            return (int)yval;
        }
        if ((int)yval > this.im.yorigin) {
            return this.im.yorigin + 2;
        }
        if ((int)yval < this.im.yorigin - this.im.ysize) {
            return this.im.yorigin - this.im.ysize - 2;
        }
        return (int)yval;
    }
}

