/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.openconfig.connector;

import io.netty.util.internal.SocketUtils;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opennms.core.ipc.sink.api.AsyncDispatcher;
import org.opennms.core.ipc.sink.api.Message;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.features.openconfig.api.OpenConfigClient;
import org.opennms.features.openconfig.api.OpenConfigClientFactory;
import org.opennms.netmgt.telemetry.api.receiver.Connector;
import org.opennms.netmgt.telemetry.api.receiver.TelemetryMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenConfigConnector
implements Connector {
    private static final Logger LOG = LoggerFactory.getLogger(OpenConfigConnector.class);
    private final OpenConfigClientFactory clientFactory;
    private final AsyncDispatcher<TelemetryMessage> dispatcher;
    private OpenConfigClient openConfigClient;

    public OpenConfigConnector(AsyncDispatcher<TelemetryMessage> dispatcher, OpenConfigClientFactory clientFactory) {
        this.dispatcher = Objects.requireNonNull(dispatcher);
        this.clientFactory = Objects.requireNonNull(clientFactory);
    }

    public void stream(int nodeId, InetAddress ipAddress, List<Map<String, String>> paramList) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting new OpenConfig client for: {}", (Object)InetAddressUtils.str((InetAddress)ipAddress));
        }
        this.openConfigClient = this.clientFactory.create(ipAddress, paramList);
        this.openConfigClient.subscribe(new OpenConfigClient.Handler(){

            public void accept(InetAddress host, Integer port, byte[] data) {
                InetSocketAddress remoteAddress = SocketUtils.socketAddress((String)host.getHostAddress(), (int)port);
                TelemetryMessage msg = new TelemetryMessage(remoteAddress, ByteBuffer.wrap(data));
                OpenConfigConnector.this.dispatcher.send((Message)msg);
            }

            public void onError(String error) {
                LOG.warn("Error while streaming openconfig data, {}", (Object)error);
            }
        });
    }

    public void close() {
        this.openConfigClient.shutdown();
    }
}

