/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.blueprint.context.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.aries.blueprint.ParserContext;
import org.apache.aries.blueprint.mutable.MutableBeanMetadata;
import org.apache.aries.blueprint.mutable.MutableValueMetadata;
import org.apache.xbean.blueprint.context.impl.DefaultProperty;
import org.apache.xbean.blueprint.context.impl.MappingMetaData;
import org.osgi.service.blueprint.container.ComponentDefinitionException;
import org.osgi.service.blueprint.reflect.BeanProperty;
import org.osgi.service.blueprint.reflect.Metadata;

public class NamedConstructorArgs {
    private Map<PropertyKey, String> defaultValues = new HashMap<PropertyKey, String>();
    private static final Map<Class, String> DEFAULT_VALUE;

    public List<DefaultProperty> getDefaultValues() {
        LinkedList<DefaultProperty> values = new LinkedList<DefaultProperty>();
        for (Map.Entry<PropertyKey, String> entry : this.defaultValues.entrySet()) {
            PropertyKey key = entry.getKey();
            String value = entry.getValue();
            values.add(new DefaultProperty(key.name, key.type, value));
        }
        return values;
    }

    public void setDefaultValues(List<DefaultProperty> defaultValues) {
        this.defaultValues.clear();
        for (DefaultProperty defaultValue : defaultValues) {
            this.addDefaultValue(defaultValue);
        }
    }

    public void addDefaultValue(String name, Class type, String value) {
        this.defaultValues.put(new PropertyKey(name, type), value);
    }

    private void addDefaultValue(DefaultProperty defaultProperty) {
        this.defaultValues.put(new PropertyKey(defaultProperty.getName(), defaultProperty.getType()), defaultProperty.getValue());
    }

    public void processParameters(MutableBeanMetadata beanMetadata, MappingMetaData metadata, ParserContext parserContext) {
        if (beanMetadata.getArguments().size() > 0) {
            return;
        }
        ConstructionInfo constructionInfo = this.selectConstructionMethod(beanMetadata, metadata);
        if (constructionInfo == null) {
            return;
        }
        List beanProperties = beanMetadata.getProperties();
        LinkedHashMap<String, BeanProperty> propMap = new LinkedHashMap<String, BeanProperty>();
        for (BeanProperty beanProperty : beanProperties) {
            propMap.put(beanProperty.getName(), beanProperty);
        }
        String[] parameterNames = constructionInfo.parameterNames;
        Class[] parameterTypes = constructionInfo.parameterTypes;
        for (int i = 0; i < parameterNames.length; ++i) {
            String parameterName = parameterNames[i];
            Class parameterType = parameterTypes[i];
            BeanProperty beanProperty = (BeanProperty)propMap.get(parameterName);
            if (beanProperty != null) {
                propMap.remove(parameterName);
                beanMetadata.removeProperty(beanProperty);
                beanMetadata.addArgument(beanProperty.getValue(), parameterType.getName(), i);
                continue;
            }
            String defaultValue = this.defaultValues.get(new PropertyKey(parameterName, parameterType));
            if (defaultValue == null) {
                defaultValue = DEFAULT_VALUE.get(parameterType);
            }
            MutableValueMetadata valueMetadata = (MutableValueMetadata)parserContext.createMetadata(MutableValueMetadata.class);
            valueMetadata.setStringValue(defaultValue);
            valueMetadata.setType(parameterType.getName());
            beanMetadata.addArgument((Metadata)valueMetadata, parameterType.getName(), i);
        }
    }

    private ConstructionInfo selectConstructionMethod(MutableBeanMetadata beanMetadata, MappingMetaData metadata) {
        Class beanClass = beanMetadata.getRuntimeClass();
        HashSet<String> definedProperties = new HashSet<String>();
        List values = beanMetadata.getProperties();
        for (BeanProperty beanProperty : values) {
            definedProperties.add(beanProperty.getName());
        }
        if (beanMetadata.getFactoryMethod() != null) {
            return this.selectFactory(beanClass, beanMetadata, metadata, definedProperties);
        }
        return this.selectConstructor(beanClass, metadata, definedProperties);
    }

    private ConstructionInfo selectFactory(Class beanClass, MutableBeanMetadata beanMetadata, MappingMetaData metadata, Set definedProperties) {
        String factoryMethodName = beanMetadata.getFactoryMethod();
        Method[] methods = beanClass.getMethods();
        ArrayList<Method> factoryMethods = new ArrayList<Method>(methods.length);
        for (Method method : methods) {
            if (!method.getName().equals(factoryMethodName)) continue;
            factoryMethods.add(method);
        }
        Collections.sort(factoryMethods, new MethodArgLengthComparator());
        for (Method factoryMethod : factoryMethods) {
            if (!metadata.isDefaultFactoryMethod(beanClass, factoryMethod)) continue;
            return new ConstructionInfo(beanClass, factoryMethod, metadata);
        }
        for (Method factoryMethod : factoryMethods) {
            ConstructionInfo constructionInfo = new ConstructionInfo(beanClass, factoryMethod, metadata);
            if (!this.isUsableConstructor(constructionInfo, definedProperties)) continue;
            return constructionInfo;
        }
        return null;
    }

    private ConstructionInfo selectConstructor(Class beanClass, MappingMetaData metadata, Set definedProperties) {
        ArrayList constructors = new ArrayList(Arrays.asList(beanClass.getConstructors()));
        Collections.sort(constructors, new ConstructorArgLengthComparator());
        for (Constructor constructor : constructors) {
            if (!metadata.isDefaultConstructor(constructor)) continue;
            return new ConstructionInfo(constructor, metadata);
        }
        for (Constructor constructor : constructors) {
            ConstructionInfo constructionInfo = new ConstructionInfo(constructor, metadata);
            if (!this.isUsableConstructor(constructionInfo, definedProperties)) continue;
            return constructionInfo;
        }
        return null;
    }

    private boolean isUsableConstructor(ConstructionInfo constructionInfo, Set definedProperties) {
        String[] parameterNames = constructionInfo.parameterNames;
        if (parameterNames == null) {
            return false;
        }
        Class[] parameterTypes = constructionInfo.parameterTypes;
        for (int i = 0; i < parameterNames.length; ++i) {
            String parameterName = parameterNames[i];
            Class parameterType = parameterTypes[i];
            if (definedProperties.contains(parameterName) || this.defaultValues.containsKey(new PropertyKey(parameterName, parameterType))) continue;
            return false;
        }
        return true;
    }

    static {
        HashMap<Class<Comparable<Boolean>>, String> temp = new HashMap<Class<Comparable<Boolean>>, String>();
        temp.put(Boolean.TYPE, Boolean.FALSE.toString());
        temp.put(Byte.TYPE, "0B");
        temp.put(Character.TYPE, "\\u000");
        temp.put(Short.TYPE, "0S");
        temp.put(Integer.TYPE, "0");
        temp.put(Long.TYPE, "0L");
        temp.put(Float.TYPE, "0F");
        temp.put(Double.TYPE, "0D");
        DEFAULT_VALUE = Collections.unmodifiableMap(temp);
    }

    private static class PropertyKey {
        private final String name;
        private final Class type;

        public PropertyKey(String name, Class type) {
            this.name = name;
            this.type = type;
        }

        public boolean equals(Object object) {
            if (!(object instanceof PropertyKey)) {
                return false;
            }
            PropertyKey defaultProperty = (PropertyKey)object;
            return this.name.equals(defaultProperty.name) && this.type.equals(this.type);
        }

        public int hashCode() {
            int result = 17;
            result = 37 * result + this.name.hashCode();
            result = 37 * result + this.type.hashCode();
            return result;
        }

        public String toString() {
            return "[" + this.name + " " + this.type + "]";
        }
    }

    private static class ConstructorArgLengthComparator
    implements Comparator<Constructor> {
        private ConstructorArgLengthComparator() {
        }

        @Override
        public int compare(Constructor o1, Constructor o2) {
            return this.getArgLength(o2) - this.getArgLength(o1);
        }

        private int getArgLength(Constructor object) {
            return object.getParameterTypes().length;
        }
    }

    private static class MethodArgLengthComparator
    implements Comparator<Method> {
        private MethodArgLengthComparator() {
        }

        @Override
        public int compare(Method o1, Method o2) {
            return this.getArgLength(o2) - this.getArgLength(o1);
        }

        private int getArgLength(Method object) {
            return object.getParameterTypes().length;
        }
    }

    private class ConstructionInfo {
        private final Class[] parameterTypes;
        private final String[] parameterNames;

        public ConstructionInfo(Constructor constructor, MappingMetaData metadata) {
            this.parameterTypes = constructor.getParameterTypes();
            String[] names = metadata.getParameterNames(constructor);
            int expectedParameterCount = this.parameterTypes.length;
            if (names != null && names.length != expectedParameterCount) {
                throw new ComponentDefinitionException("Excpected " + expectedParameterCount + " parameter names for constructor but only got " + names.length + ": " + constructor.toString());
            }
            if (expectedParameterCount == 0) {
                names = new String[]{};
            }
            this.parameterNames = names;
        }

        public ConstructionInfo(Class beanClass, Method factoryMethod, MappingMetaData metadata) {
            this.parameterTypes = factoryMethod.getParameterTypes();
            String[] names = metadata.getParameterNames(beanClass, factoryMethod);
            int expectedParameterCount = this.parameterTypes.length;
            if (names != null && names.length != expectedParameterCount) {
                throw new ComponentDefinitionException("Excpected " + expectedParameterCount + " parameter names for factory method but only got " + names.length + ": " + factoryMethod.toString());
            }
            if (expectedParameterCount == 0) {
                names = new String[]{};
            }
            this.parameterNames = names;
        }
    }
}

