/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.deviceconfig.sink.consumer;

import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import java.util.Optional;
import org.opennms.core.ipc.sink.api.MessageConsumer;
import org.opennms.core.ipc.sink.api.MessageConsumerManager;
import org.opennms.core.ipc.sink.api.SinkModule;
import org.opennms.features.deviceconfig.persistence.api.DeviceConfigDao;
import org.opennms.features.deviceconfig.service.DeviceConfigUtil;
import org.opennms.features.deviceconfig.sink.module.DeviceConfigSinkDTO;
import org.opennms.features.deviceconfig.sink.module.DeviceConfigSinkModule;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceConfigConsumer
implements MessageConsumer<DeviceConfigSinkDTO, DeviceConfigSinkDTO>,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(DeviceConfigConsumer.class);
    private static final String DEVICE_CONFIG_PREFIX = "DeviceConfig";
    private final MessageConsumerManager consumerManager;
    private final DeviceConfigSinkModule module;
    private final IpInterfaceDao ipInterfaceDao;
    private final DeviceConfigDao deviceConfigDao;

    public DeviceConfigConsumer(MessageConsumerManager consumerManager, DeviceConfigSinkModule module, IpInterfaceDao ipInterfaceDao, DeviceConfigDao deviceConfigDao) throws Exception {
        this.consumerManager = consumerManager;
        this.module = module;
        this.ipInterfaceDao = ipInterfaceDao;
        this.deviceConfigDao = deviceConfigDao;
        this.consumerManager.registerConsumer((MessageConsumer)this);
    }

    public SinkModule<DeviceConfigSinkDTO, DeviceConfigSinkDTO> getModule() {
        return this.module;
    }

    public void handleMessage(DeviceConfigSinkDTO message) {
        block6: {
            try {
                InetAddress address = InetAddress.getByAddress(message.address);
                LOG.debug("handle message - location: " + message.location + "; address: " + address.getHostAddress() + "; fileName: " + message.fileName);
                OnmsIpInterface ipInterface = this.findMatchingInterface(address.getHostAddress(), message.location);
                if (ipInterface != null) {
                    byte[] content = message.config;
                    if (DeviceConfigUtil.isGzipFile((String)message.fileName)) {
                        try {
                            content = DeviceConfigUtil.decompressGzipToBytes((byte[])content);
                        }
                        catch (IOException e) {
                            LOG.warn("Failed to decompress content from file {}", (Object)message.fileName);
                        }
                    }
                    this.deviceConfigDao.updateDeviceConfigContent(ipInterface, null, "sink", null, content, message.fileName);
                    break block6;
                }
                LOG.warn("can not persist device config; did not find interface - location: " + message.location + "; " + address.getHostAddress());
            }
            catch (Exception e) {
                LOG.error("could not handle device config backup message", (Throwable)e);
            }
        }
    }

    private OnmsIpInterface findMatchingInterface(String ipAddress, String location) {
        OnmsIpInterface iface;
        List ipInterfaces = this.ipInterfaceDao.findByIpAddressAndLocation(ipAddress, location);
        OnmsIpInterface onmsIpInterface = iface = ipInterfaces.size() > 0 ? (OnmsIpInterface)ipInterfaces.get(0) : null;
        if (ipInterfaces.size() > 1) {
            Optional<OnmsIpInterface> optionalInterface = ipInterfaces.stream().filter(ipInterface -> ipInterface.getMonitoredServices().stream().anyMatch(monitoredService -> monitoredService.getServiceName().startsWith(DEVICE_CONFIG_PREFIX))).findFirst();
            iface = optionalInterface.orElseGet(() -> ipInterfaces.stream().findFirst().orElse(null));
        }
        return iface;
    }

    @Override
    public void close() throws Exception {
        this.consumerManager.unregisterConsumer((MessageConsumer)this);
    }
}

