/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MutableCollections {
    public static <T> List<T> copyListFromNullable(Collection<T> toCopy, Supplier<List<T>> listSupplier) {
        return Optional.ofNullable(toCopy).map(Collection::stream).orElseGet(Stream::empty).collect(Collectors.toCollection(listSupplier));
    }

    public static <T> List<T> copyListFromNullable(Collection<T> toCopy) {
        return MutableCollections.copyListFromNullable(toCopy, ArrayList::new);
    }

    public static <T, S> Map<T, S> copyMapFromNullable(Map<T, S> toCopy, Supplier<Map<T, S>> mapSupplier) {
        Map<T, S> map = mapSupplier.get();
        if (toCopy == null || toCopy.isEmpty()) {
            return map;
        }
        map.putAll(toCopy);
        return map;
    }

    public static <T, S> Map<T, S> copyMapFromNullable(Map<T, S> toCopy) {
        return MutableCollections.copyMapFromNullable(toCopy, HashMap::new);
    }
}

