/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.ipc.sink.offheap;

import java.util.Objects;
import java.util.function.Function;
import org.opennms.core.ipc.sink.offheap.OffHeapDataBlock;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;

public class RocksDBOffHeapDataBlock<T>
extends OffHeapDataBlock<T> {
    private RocksDB rocksdb;

    public RocksDBOffHeapDataBlock(String name, int queueSize, Function<T, byte[]> serializer, Function<byte[], T> deserializer, RocksDB rocksdb, byte[] data) {
        super(name, queueSize, serializer, deserializer, data);
        this.rocksdb = Objects.requireNonNull(rocksdb);
    }

    public RocksDBOffHeapDataBlock(int queueSize, Function<T, byte[]> serializer, Function<byte[], T> deserializer, RocksDB rocksdb) {
        this(null, queueSize, serializer, deserializer, rocksdb, null);
    }

    @Override
    void writeData(String key, byte[] data) {
        try {
            this.rocksdb.put(key.getBytes(), data);
        }
        catch (RocksDBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    byte[] loadData(String key) {
        try {
            byte[] data = this.rocksdb.get(key.getBytes());
            this.rocksdb.delete(key.getBytes());
            return data;
        }
        catch (RocksDBException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

