/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip;

import gov.nist.javax.sip.DialogFilter;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.ServerRequestInterface;
import gov.nist.javax.sip.stack.ServerResponseInterface;
import gov.nist.javax.sip.stack.StackMessageFactory;

class NistSipMessageFactoryImpl
implements StackMessageFactory {
    private SIPTransactionStack sipStack;

    public ServerRequestInterface newSIPServerRequest(SIPRequest sipRequest, MessageChannel messageChannel) {
        if (messageChannel == null || sipRequest == null) {
            throw new IllegalArgumentException("Null Arg!");
        }
        SIPTransactionStack theStack = messageChannel.getSIPStack();
        DialogFilter retval = new DialogFilter(theStack);
        if (messageChannel instanceof SIPTransaction) {
            retval.transactionChannel = (SIPTransaction)messageChannel;
        }
        retval.listeningPoint = messageChannel.getMessageProcessor().getListeningPoint();
        if (retval.listeningPoint == null) {
            return null;
        }
        if (this.sipStack.isLoggingEnabled(32)) {
            this.sipStack.getStackLogger().logDebug("Returning request interface for " + sipRequest.getFirstLine() + " " + retval + " messageChannel = " + messageChannel);
        }
        return retval;
    }

    public ServerResponseInterface newSIPServerResponse(SIPResponse sipResponse, MessageChannel messageChannel) {
        SIPTransactionStack theStack = messageChannel.getSIPStack();
        SIPTransaction tr = theStack.findTransaction(sipResponse, false);
        if (this.sipStack.isLoggingEnabled(32)) {
            this.sipStack.getStackLogger().logDebug("Found Transaction " + tr + " for " + sipResponse);
        }
        if (tr != null) {
            if (tr.getInternalState() < 0) {
                if (this.sipStack.isLoggingEnabled(32)) {
                    this.sipStack.getStackLogger().logDebug("Dropping response - null transaction state");
                }
                return null;
            }
            if (3 == tr.getInternalState() && sipResponse.getStatusCode() / 100 == 1) {
                if (this.sipStack.isLoggingEnabled(32)) {
                    this.sipStack.getStackLogger().logDebug("Dropping response - late arriving " + sipResponse.getStatusCode());
                }
                return null;
            }
        }
        DialogFilter retval = new DialogFilter(this.sipStack);
        retval.transactionChannel = tr;
        retval.listeningPoint = messageChannel.getMessageProcessor().getListeningPoint();
        return retval;
    }

    public NistSipMessageFactoryImpl(SIPTransactionStack sipStackImpl) {
        this.sipStack = sipStackImpl;
    }
}

