/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.sdp;

import io.pkts.buffer.Buffer;
import io.pkts.sdp.SDP;
import io.pkts.sdp.SdpException;
import io.pkts.sdp.SdpParseException;
import io.pkts.sdp.impl.SDPWrapper;
import javax.sdp.SdpFactory;
import javax.sdp.SessionDescription;

public final class SDPFactory {
    private static final SdpFactory sdpFactory = SdpFactory.getInstance();
    private static final SDPFactory instance = new SDPFactory();

    private SDPFactory() {
    }

    public static SDPFactory getInstance() {
        return instance;
    }

    public SDP parse(Buffer data) throws SdpException {
        try {
            SessionDescription sdp = sdpFactory.createSessionDescription(data.toString());
            return new SDPWrapper(sdp);
        }
        catch (javax.sdp.SdpParseException e) {
            throw new SdpParseException(e.getLineNumber(), e.getCharOffset(), e.getMessage(), e.getCause());
        }
    }
}

