/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.graph;

import org.apache.kafka.streams.kstream.internals.KTableSource;
import org.apache.kafka.streams.kstream.internals.KeyValueStoreMaterializer;
import org.apache.kafka.streams.kstream.internals.MaterializedInternal;
import org.apache.kafka.streams.kstream.internals.graph.GraphNode;
import org.apache.kafka.streams.kstream.internals.graph.ProcessorParameters;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;
import org.apache.kafka.streams.state.StoreBuilder;

public class StreamToTableNode<K, V>
extends GraphNode {
    private final ProcessorParameters<K, V, ?, ?> processorParameters;
    private final MaterializedInternal<K, V, ?> materializedInternal;

    public StreamToTableNode(String nodeName, ProcessorParameters<K, V, ?, ?> processorParameters, MaterializedInternal<K, V, ?> materializedInternal) {
        super(nodeName);
        this.processorParameters = processorParameters;
        this.materializedInternal = materializedInternal;
    }

    @Override
    public String toString() {
        return "StreamToTableNode{, processorParameters=" + this.processorParameters + ", materializedInternal=" + this.materializedInternal + "} " + super.toString();
    }

    @Override
    public void writeToTopology(InternalTopologyBuilder topologyBuilder) {
        StoreBuilder<?> storeBuilder = new KeyValueStoreMaterializer<K, V>(this.materializedInternal).materialize();
        String processorName = this.processorParameters.processorName();
        KTableSource tableSource = this.processorParameters.processorSupplier() instanceof KTableSource ? (KTableSource)this.processorParameters.processorSupplier() : null;
        topologyBuilder.addProcessor(processorName, this.processorParameters.processorSupplier(), this.parentNodeNames());
        if (storeBuilder != null && tableSource.materialized()) {
            topologyBuilder.addStateStore(storeBuilder, processorName);
        }
    }
}

