/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.schema.walker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAttribute;
import org.apache.ws.commons.schema.XmlSchemaAttributeGroup;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaGroup;
import org.apache.ws.commons.schema.XmlSchemaType;

class SchemasByNamespace {
    private final Map<String, List<XmlSchema>> mData = new HashMap<String, List<XmlSchema>>();

    SchemasByNamespace() {
    }

    public void addSchema(String aNamespace, XmlSchema aSchema) {
        List<XmlSchema> value;
        if (aNamespace == null) {
            aNamespace = "";
        }
        if ((value = this.mData.get(aNamespace)) == null) {
            value = new ArrayList<XmlSchema>();
            this.mData.put(aNamespace, value);
        }
        value.add(aSchema);
    }

    public XmlSchema[] getSchemas(String aNamespace) {
        List<XmlSchema> l;
        if (aNamespace == null) {
            aNamespace = "";
        }
        return (l = this.mData.get(aNamespace)) == null ? new XmlSchema[]{} : l.toArray(new XmlSchema[l.size()]);
    }

    public XmlSchemaType getTypeByName(QName aTypeName) {
        XmlSchema[] schemas;
        for (XmlSchema s : schemas = this.getSchemas(aTypeName.getNamespaceURI())) {
            XmlSchemaType t = s.getTypeByName(aTypeName);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    public XmlSchemaGroup getGroupByName(QName aGroupName) {
        XmlSchema[] schemas;
        for (XmlSchema s : schemas = this.getSchemas(aGroupName.getNamespaceURI())) {
            XmlSchemaGroup g = s.getGroupByName(aGroupName);
            if (g == null) continue;
            return g;
        }
        return null;
    }

    public XmlSchemaAttribute getAttributeByName(QName aAttName) {
        XmlSchema[] schemas;
        for (XmlSchema s : schemas = this.getSchemas(aAttName.getNamespaceURI())) {
            XmlSchemaAttribute a = s.getAttributeByName(aAttName);
            if (a == null) continue;
            return a;
        }
        return null;
    }

    public XmlSchemaAttributeGroup getAttributeGroupByName(QName aAGName) {
        XmlSchema[] schemas;
        for (XmlSchema s : schemas = this.getSchemas(aAGName.getNamespaceURI())) {
            XmlSchemaAttributeGroup ag = s.getAttributeGroupByName(aAGName);
            if (ag == null) continue;
            return ag;
        }
        return null;
    }

    public XmlSchemaElement getElementByName(QName aElementName) {
        XmlSchema[] schemas;
        for (XmlSchema s : schemas = this.getSchemas(aElementName.getNamespaceURI())) {
            XmlSchemaElement e = s.getElementByName(aElementName);
            if (e == null) continue;
            return e;
        }
        return null;
    }

    public XmlSchema getSchemaDefiningElement(QName aElementName) {
        XmlSchema[] schemas;
        for (XmlSchema s : schemas = this.getSchemas(aElementName.getNamespaceURI())) {
            XmlSchemaElement e = s.getElementByName(aElementName);
            if (e == null) continue;
            return s;
        }
        return null;
    }

    public XmlSchema getSchemaDefiningAttribute(QName aAttName) {
        XmlSchema[] schemas;
        for (XmlSchema s : schemas = this.getSchemas(aAttName.getNamespaceURI())) {
            XmlSchemaAttribute a = s.getAttributeByName(aAttName);
            if (a == null) continue;
            return s;
        }
        return null;
    }

    public XmlSchema getFirstSchema(String aNamespace) {
        XmlSchema[] schemas = this.getSchemas(aNamespace);
        if (schemas.length > 0) {
            return schemas[0];
        }
        return null;
    }
}

