/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.osgi;

import java.util.List;
import org.opennms.osgi.EventListener;
import org.opennms.osgi.EventProxy;
import org.opennms.osgi.OnmsServiceManager;
import org.opennms.osgi.VaadinApplicationContext;
import org.opennms.osgi.locator.OnmsServiceManagerLocator;
import org.osgi.framework.BundleContext;

class EventProxyImpl
implements EventProxy {
    private final BundleContext bundleContext;
    private final VaadinApplicationContext applicationContext;

    protected EventProxyImpl(BundleContext bundleContext, VaadinApplicationContext applicationContext) {
        this.bundleContext = bundleContext;
        this.applicationContext = applicationContext;
    }

    @Override
    public <T> void fireEvent(T eventObject) {
        if (eventObject == null) {
            return;
        }
        List<EventListener> eventListeners = this.getServiceManager().getServices(EventListener.class, this.applicationContext, EventListener.getProperties(eventObject.getClass()));
        for (EventListener eachListener : eventListeners) {
            eachListener.invoke(eventObject);
        }
    }

    @Override
    public <T> void addPossibleEventConsumer(T possibleEventConsumer) {
        this.getServiceManager().getEventRegistry().addPossibleEventConsumer(possibleEventConsumer, this.applicationContext);
    }

    private OnmsServiceManager getServiceManager() {
        return new OnmsServiceManagerLocator().lookup(this.bundleContext);
    }
}

