/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.connector.work.pool;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.geronimo.connector.work.pool.NullWorkExecutorPool;
import org.apache.geronimo.connector.work.pool.WorkExecutorPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkExecutorPoolImpl
implements WorkExecutorPool {
    private ThreadPoolExecutor pooledExecutor;
    private static Logger log = LoggerFactory.getLogger(WorkExecutorPoolImpl.class);

    public WorkExecutorPoolImpl(int maxSize) {
        this.pooledExecutor = new ThreadPoolExecutor(1, maxSize, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    @Override
    public void execute(Runnable work) {
        if (this.pooledExecutor.getPoolSize() == this.pooledExecutor.getMaximumPoolSize()) {
            log.warn("Maximum Pool size has been exceeded.  Current Pool Size = " + this.pooledExecutor.getMaximumPoolSize());
        }
        this.pooledExecutor.execute(work);
    }

    @Override
    public int getPoolSize() {
        return this.pooledExecutor.getPoolSize();
    }

    @Override
    public int getMaximumPoolSize() {
        return this.pooledExecutor.getMaximumPoolSize();
    }

    @Override
    public void setMaximumPoolSize(int maxSize) {
        this.pooledExecutor.setMaximumPoolSize(maxSize);
    }

    @Override
    public WorkExecutorPool start() {
        throw new IllegalStateException("This pooled executor is already started");
    }

    @Override
    public WorkExecutorPool stop() {
        int maxSize = this.getMaximumPoolSize();
        this.pooledExecutor.shutdown();
        return new NullWorkExecutorPool(maxSize);
    }
}

