/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.statsd;

import java.util.Collection;
import java.util.HashSet;
import org.opennms.netmgt.config.statsd.model.PackageReport;
import org.opennms.netmgt.config.statsd.model.Report;
import org.opennms.netmgt.config.statsd.model.StatsdPackage;
import org.opennms.netmgt.dao.api.StatisticsDaemonConfigDao;
import org.opennms.netmgt.model.AttributeStatisticVisitorWithResults;
import org.opennms.netmgt.statsd.ReportDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.util.Assert;

public class ReportDefinitionBuilder
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(ReportDefinitionBuilder.class);
    private StatisticsDaemonConfigDao m_statsdConfigDao;

    public void reload() throws DataAccessResourceFailureException {
        this.m_statsdConfigDao.reloadConfiguration();
    }

    public Collection<ReportDefinition> buildReportDefinitions() throws Exception {
        HashSet<ReportDefinition> reportDefinitions = new HashSet<ReportDefinition>();
        for (StatsdPackage pkg : this.m_statsdConfigDao.getPackages()) {
            for (PackageReport packageReport : pkg.getReports()) {
                Class<? extends AttributeStatisticVisitorWithResults> clazz;
                Report report = packageReport.getReport();
                if (!packageReport.isEnabled()) {
                    LOG.debug("skipping report '{}' in package '{}' because the report is not enabled", (Object)report.getName(), (Object)pkg.getName());
                    continue;
                }
                try {
                    clazz = this.createClassForReport(report);
                }
                catch (ClassNotFoundException e) {
                    throw new DataAccessResourceFailureException("Could not find class '" + report.getClassName() + "'; nested exception: " + String.valueOf(e), (Throwable)e);
                }
                Assert.isAssignable(AttributeStatisticVisitorWithResults.class, clazz, (String)("the class specified by class-name in the '" + report.getName() + "' report does not implement the interface " + AttributeStatisticVisitorWithResults.class.getName() + "; "));
                ReportDefinition reportDef = new ReportDefinition();
                reportDef.setReport(packageReport);
                reportDef.setReportClass(clazz);
                BeanWrapper bw = PropertyAccessorFactory.forBeanPropertyAccess((Object)reportDef);
                try {
                    bw.setPropertyValues(packageReport.getAggregateParameters());
                }
                catch (BeansException e) {
                    LOG.error("Could not set properties on report definition: {}", (Object)e.getMessage(), (Object)e);
                }
                reportDef.afterPropertiesSet();
                reportDefinitions.add(reportDef);
            }
        }
        return reportDefinitions;
    }

    private Class<? extends AttributeStatisticVisitorWithResults> createClassForReport(Report report) throws ClassNotFoundException {
        return Class.forName(report.getClassName());
    }

    public void afterPropertiesSet() {
        Assert.state((this.m_statsdConfigDao != null ? 1 : 0) != 0, (String)"property statsdConfigDao must be set to a non-null value");
    }

    public StatisticsDaemonConfigDao getStatsdConfigDao() {
        return this.m_statsdConfigDao;
    }

    public void setStatsdConfigDao(StatisticsDaemonConfigDao statsdConfigDao) {
        this.m_statsdConfigDao = statsdConfigDao;
    }
}

