/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.jmx;

import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.opennms.netmgt.daemon.AbstractSpringContextJmxServiceDaemon;
import org.opennms.netmgt.poller.Poller;
import org.opennms.netmgt.poller.jmx.PollerdMBean;
import org.opennms.netmgt.poller.pollables.PollableService;
import org.opennms.netmgt.scheduler.LegacyScheduler;
import org.opennms.netmgt.scheduler.Schedule;

public class Pollerd
extends AbstractSpringContextJmxServiceDaemon<Poller>
implements PollerdMBean {
    private static final String[] SCHEDULE_ITEMS = new String[]{"nodeId", "nodeLabel", "nodeLocation", "ipAddress", "service", "readyTimeMs", "readyTimeAbsoluteMs", "status", "statusChangeTimeMs"};
    private static final String[] SCHEDULE_DESCS = new String[]{"nodeId", "nodeLabel", "nodeLocation", "ipAddress", "service", "readyTimeMs", "readyTimeAbsoluteMs", "status", "statusChangeTimeMs"};
    private static final OpenType<?>[] SCHEDULE_TYPES = new OpenType[]{SimpleType.INTEGER, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.LONG, SimpleType.LONG, SimpleType.STRING, SimpleType.LONG};
    public static final CompositeType SCHEDULE_COMPOSITE_TYPE;
    public static final TabularType SCHEDULE_TABULAR_TYPE;

    protected String getLoggingPrefix() {
        return Poller.getLoggingCategory();
    }

    protected String getSpringContext() {
        return "pollerdContext";
    }

    @Override
    public long getActiveThreads() {
        if (this.getThreadPoolStatsStatus()) {
            return this.getExecutor().getActiveCount();
        }
        return 0L;
    }

    @Override
    public long getTasksTotal() {
        if (this.getThreadPoolStatsStatus()) {
            return this.getExecutor().getTaskCount();
        }
        return 0L;
    }

    @Override
    public long getTasksCompleted() {
        if (this.getThreadPoolStatsStatus()) {
            return this.getExecutor().getCompletedTaskCount();
        }
        return 0L;
    }

    @Override
    public long getNumPolls() {
        return ((Poller)this.getDaemon()).getNumPolls();
    }

    @Override
    public double getTaskCompletionRatio() {
        if (this.getThreadPoolStatsStatus()) {
            if (this.getExecutor().getTaskCount() > 0L) {
                return new Double((double)this.getExecutor().getCompletedTaskCount() / new Double(this.getExecutor().getTaskCount()));
            }
            return new Double(0.0);
        }
        return new Double(0.0);
    }

    @Override
    public long getNumPoolThreads() {
        if (this.getThreadPoolStatsStatus()) {
            return this.getExecutor().getPoolSize();
        }
        return 0L;
    }

    @Override
    public long getPeakPoolThreads() {
        if (this.getThreadPoolStatsStatus()) {
            return this.getExecutor().getLargestPoolSize();
        }
        return 0L;
    }

    @Override
    public long getCorePoolThreads() {
        if (this.getThreadPoolStatsStatus()) {
            return this.getExecutor().getCorePoolSize();
        }
        return 0L;
    }

    @Override
    public long getMaxPoolThreads() {
        if (this.getThreadPoolStatsStatus()) {
            return this.getExecutor().getMaximumPoolSize();
        }
        return 0L;
    }

    @Override
    public long getTaskQueuePendingCount() {
        if (this.getThreadPoolStatsStatus()) {
            return this.getExecutor().getQueue().size();
        }
        return 0L;
    }

    @Override
    public long getTaskQueueRemainingCapacity() {
        if (this.getThreadPoolStatsStatus()) {
            return this.getExecutor().getQueue().remainingCapacity();
        }
        return 0L;
    }

    @Override
    public long getNumPollsInFlight() {
        return ((Poller)this.getDaemon()).getNetwork().getContext().getAsyncPollingEngine().getNumPollsInFlight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TabularData getSchedule() throws OpenDataException {
        Map queue;
        long currentTimeMs = System.currentTimeMillis();
        TabularDataSupport tabularData = new TabularDataSupport(SCHEDULE_TABULAR_TYPE);
        Map map = queue = ((LegacyScheduler)((Poller)this.getDaemon()).getScheduler()).getQueue();
        synchronized (map) {
            for (Map.Entry entry : queue.entrySet()) {
                List pollableServiceList = ((BlockingQueue)entry.getValue()).stream().map(r -> (LegacyScheduler.TimeKeeper)r).collect(Collectors.toList());
                for (LegacyScheduler.TimeKeeper timeKeeper : pollableServiceList) {
                    long readyTimeAbsoluteMs = timeKeeper.getTimeToRun();
                    long readyTimeMs = readyTimeAbsoluteMs - currentTimeMs;
                    PollableService pollableService = (PollableService)((Schedule.ScheduleEntry)timeKeeper.getRunnable()).getSchedulable();
                    String ipAddress = pollableService.getIpAddr();
                    int nodeId = pollableService.getNodeId();
                    String nodeLabel = pollableService.getNodeLabel();
                    String nodeLocation = pollableService.getNodeLocation();
                    String service = pollableService.getSvcName();
                    String status = pollableService.getStatus().getStatusName();
                    long statusChangeTimeMs = pollableService.getStatusChangeTime();
                    tabularData.put(new CompositeDataSupport(SCHEDULE_COMPOSITE_TYPE, SCHEDULE_ITEMS, new Object[]{nodeId, nodeLabel, nodeLocation, ipAddress, service, readyTimeMs, readyTimeAbsoluteMs, status, statusChangeTimeMs}));
                }
            }
            return tabularData;
        }
    }

    private ThreadPoolExecutor getExecutor() {
        return (ThreadPoolExecutor)((LegacyScheduler)((Poller)this.getDaemon()).getScheduler()).getRunner();
    }

    private boolean getThreadPoolStatsStatus() {
        return ((Poller)this.getDaemon()).getScheduler() instanceof LegacyScheduler;
    }

    static {
        try {
            SCHEDULE_COMPOSITE_TYPE = new CompositeType("Pollable Service", "Scheduled Pollable Services", SCHEDULE_ITEMS, SCHEDULE_DESCS, SCHEDULE_TYPES);
            SCHEDULE_TABULAR_TYPE = new TabularType("Pollable Services", "Scheduled Pollable Service", SCHEDULE_COMPOSITE_TYPE, new String[]{"nodeId", "ipAddress", "service"});
        }
        catch (OpenDataException e) {
            throw new RuntimeException(e);
        }
    }
}

