/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.util.HashMap;
import java.util.Map;
import org.opennms.netmgt.model.OnmsIpInterface;

final class CollectorUpdates {
    private boolean m_hasUpdates;
    private Map<String, Object> m_properties;
    private boolean m_deletionFlag;
    private OnmsIpInterface m_reinitFlag = null;
    private boolean m_reparentFlag;
    private String m_reparentOldNodeId;
    private String m_reparentNewNodeId;
    private OnmsIpInterface m_newIface = null;

    CollectorUpdates() {
        this.reset();
    }

    void reset() {
        this.m_hasUpdates = false;
        this.m_properties = null;
        this.m_deletionFlag = false;
        this.m_reinitFlag = null;
        this.m_reparentFlag = false;
        this.m_reparentOldNodeId = null;
        this.m_reparentNewNodeId = null;
        this.m_newIface = null;
    }

    void setAttribute(String property, Object value) {
        if (this.m_properties == null) {
            this.m_properties = new HashMap<String, Object>();
        }
        this.m_properties.put(property, value);
        this.m_hasUpdates = true;
    }

    Object getAttribute(String property) {
        Object rc = null;
        if (this.m_properties != null) {
            rc = this.m_properties.get(property);
        }
        return rc;
    }

    void markForDeletion() {
        this.m_deletionFlag = true;
        this.m_hasUpdates = true;
    }

    void markForReinitialization(OnmsIpInterface iface) {
        this.m_reinitFlag = iface;
        this.m_hasUpdates = true;
    }

    void markForReparenting(String oldNodeId, String newNodeId, OnmsIpInterface iface) {
        this.m_reparentFlag = true;
        this.m_reparentOldNodeId = oldNodeId;
        this.m_reparentNewNodeId = newNodeId;
        this.m_newIface = iface;
        this.m_hasUpdates = true;
    }

    String getReparentOldNodeId() {
        return this.m_reparentOldNodeId;
    }

    String getReparentNewNodeId() {
        return this.m_reparentNewNodeId;
    }

    OnmsIpInterface getUpdatedInterface() {
        return this.m_newIface;
    }

    boolean hasUpdates() {
        return this.m_hasUpdates;
    }

    boolean isDeletionFlagSet() {
        return this.m_deletionFlag;
    }

    OnmsIpInterface isReinitializationNeeded() {
        return this.m_reinitFlag;
    }

    boolean isReparentingFlagSet() {
        return this.m_reparentFlag;
    }
}

