/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import java.util.Collection;
import org.opennms.netmgt.collectd.AliasedAttribute;
import org.opennms.netmgt.collectd.SnmpAttribute;
import org.opennms.netmgt.collectd.SnmpCollectionResource;
import org.opennms.netmgt.collection.api.AttributeGroup;
import org.opennms.netmgt.collection.api.AttributeGroupType;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.collection.api.CollectionResource;
import org.opennms.netmgt.collection.api.CollectionSetVisitor;
import org.opennms.netmgt.collection.api.ServiceParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliasedGroup
extends AttributeGroup {
    private static final Logger LOG = LoggerFactory.getLogger(AliasedGroup.class);
    private final AttributeGroup m_group;

    public AliasedGroup(SnmpCollectionResource resource, AttributeGroup group) {
        super((CollectionResource)resource, group.getGroupType());
        this.m_group = group;
    }

    public void addAttribute(SnmpAttribute attr) {
        this.m_group.addAttribute((CollectionAttribute)attr);
    }

    public boolean equals(Object obj) {
        return this.m_group.equals(obj);
    }

    public Collection<CollectionAttribute> getAttributes() {
        return this.m_group.getAttributes();
    }

    public AttributeGroupType getGroupType() {
        return this.m_group.getGroupType();
    }

    public String getName() {
        return this.m_group.getName();
    }

    public int hashCode() {
        return this.m_group.hashCode();
    }

    public boolean shouldPersist(ServiceParameters params) {
        return this.m_group.shouldPersist(params);
    }

    public String toString() {
        return this.m_group.toString();
    }

    public void visit(CollectionSetVisitor visitor) {
        visitor.visitGroup((AttributeGroup)this);
        for (CollectionAttribute attr : this.getAttributes()) {
            AliasedAttribute aliased = new AliasedAttribute(this.getResource(), (SnmpAttribute)attr);
            LOG.debug("visiting at aliased  = {}", (Object)aliased);
            aliased.visit(visitor);
        }
        visitor.completeGroup((AttributeGroup)this);
    }
}

