/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser.state;

import com.google.common.collect.ImmutableList;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.Value;

public class OptionState {
    public final int templateId;
    public final Duration age;
    public final List<NamedValue> selectors;
    public final List<NamedValue> values;

    public OptionState(Builder builder) {
        this.templateId = builder.templateId;
        this.age = builder.age;
        this.selectors = (List)Objects.requireNonNull(builder.selectors.build());
        this.values = (List)Objects.requireNonNull(builder.values.build());
    }

    public static Builder builder(int templateId) {
        return new Builder(templateId);
    }

    public static class Builder {
        private int templateId;
        private Duration age;
        private final ImmutableList.Builder<NamedValue> selectors = ImmutableList.builder();
        private final ImmutableList.Builder<NamedValue> values = ImmutableList.builder();

        private Builder(int templateId) {
            this.templateId = templateId;
        }

        public Builder withTemplateId(int templateId) {
            this.templateId = templateId;
            return this;
        }

        public Builder withAge(Duration age) {
            this.age = age;
            return this;
        }

        public Builder withInsertionTime(Instant insertionTime) {
            return this.withAge(Duration.between(insertionTime, Instant.now()));
        }

        public Builder withSelectors(Iterable<Value<?>> selectors) {
            for (Value<?> selector : selectors) {
                this.selectors.add((Object)NamedValue.from(selector));
            }
            return this;
        }

        public Builder withSelector(Value<?> selector) {
            this.selectors.add((Object)NamedValue.from(selector));
            return this;
        }

        public Builder withValues(Iterable<Value<?>> values) {
            for (Value<?> value : values) {
                this.values.add((Object)NamedValue.from(value));
            }
            return this;
        }

        public Builder withValue(Value<?> value) {
            this.values.add((Object)NamedValue.from(value));
            return this;
        }

        public OptionState build() {
            return new OptionState(this);
        }
    }

    public static class NamedValue {
        public final String name;
        public final String value;

        public NamedValue(String name, String value) {
            this.name = Objects.requireNonNull(name);
            this.value = Objects.requireNonNull(value);
        }

        public static NamedValue from(Value<?> value) {
            return new NamedValue(value.getName(), value.getValue().toString());
        }
    }
}

