/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser.ipfix.proto;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.MissingTemplateException;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.Value;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ipfix.proto.DataSet;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ipfix.proto.Record;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.Field;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.Session;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.Template;

public final class DataRecord
implements Record {
    public static final int VARIABLE_SIZED = 65535;
    public static final int VARIABLE_SIZED_EXTENDED = 255;
    public final DataSet set;
    public final Template template;
    public final List<Value<?>> scopes;
    public final List<Value<?>> fields;
    public final List<Value<?>> options;

    public DataRecord(DataSet set, Session.Resolver resolver, Template template, ByteBuf buffer) throws InvalidPacketException, MissingTemplateException {
        this.set = Objects.requireNonNull(set);
        this.template = Objects.requireNonNull(template);
        ArrayList scopes = new ArrayList(this.template.scopes.size());
        for (Field field : this.template.scopes) {
            scopes.add(DataRecord.parseField(field, resolver, buffer));
        }
        ArrayList fields = new ArrayList(this.template.fields.size());
        for (Field field : this.template.fields) {
            fields.add(DataRecord.parseField(field, resolver, buffer));
        }
        this.scopes = Collections.unmodifiableList(scopes);
        this.fields = Collections.unmodifiableList(fields);
        this.options = resolver.lookupOptions(this.fields);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("scopes", this.scopes).add("fields", this.fields).add("options", this.options).toString();
    }

    public static Value<?> parseField(Field field, Session.Resolver resolver, ByteBuf buffer) throws InvalidPacketException, MissingTemplateException {
        int length = field.length();
        if (length == 65535 && (length = BufferUtils.uint8((ByteBuf)buffer)) == 255) {
            length = BufferUtils.uint16((ByteBuf)buffer);
        }
        return field.parse(resolver, BufferUtils.slice((ByteBuf)buffer, (int)length));
    }
}

