/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.listeners.factory;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.netmgt.telemetry.api.receiver.Listener;
import org.opennms.netmgt.telemetry.api.receiver.ListenerFactory;
import org.opennms.netmgt.telemetry.api.registry.TelemetryRegistry;
import org.opennms.netmgt.telemetry.config.api.ListenerDefinition;
import org.opennms.netmgt.telemetry.listeners.UdpListener;
import org.opennms.netmgt.telemetry.listeners.UdpParser;

public class UdpListenerFactory
implements ListenerFactory {
    private TelemetryRegistry telemetryRegistry;

    public UdpListenerFactory(TelemetryRegistry telemetryRegistry) {
        this.telemetryRegistry = Objects.requireNonNull(telemetryRegistry);
    }

    public Class<? extends Listener> getBeanClass() {
        return UdpListener.class;
    }

    public Listener createBean(ListenerDefinition listenerDefinition) {
        List parsers = listenerDefinition.getParsers().stream().map(p -> this.telemetryRegistry.getParser(p)).collect(Collectors.toList());
        List<UdpParser> udpParsers = parsers.stream().filter(p -> p instanceof UdpParser).map(p -> (UdpParser)p).collect(Collectors.toList());
        if (parsers.size() != udpParsers.size()) {
            throw new IllegalArgumentException("Each parser must be of type UdpParser but was not: " + String.valueOf(parsers));
        }
        return new UdpListener(listenerDefinition.getName(), udpParsers, this.telemetryRegistry.getMetricRegistry());
    }
}

