/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.SampleDatagramEnrichment;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.SampleDatagramVisitor;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.Array;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.FlowData;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.Pdu;

public class Extended80211Aggregation
implements FlowData {
    public final Array<Pdu> pdus;

    public Extended80211Aggregation(ByteBuf buffer) throws InvalidPacketException {
        this.pdus = new Array<Object>(buffer, Optional.empty(), Pdu::new);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("pdus", this.pdus).toString();
    }

    @Override
    public void writeBson(BsonWriter bsonWriter, SampleDatagramEnrichment enr) {
        bsonWriter.writeStartArray();
        for (Pdu pdu : this.pdus) {
            pdu.writeBson(bsonWriter, enr);
        }
        bsonWriter.writeEndArray();
    }

    @Override
    public void visit(SampleDatagramVisitor visitor) {
        visitor.accept(this);
    }
}

