/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.sflow.parser.proto;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.InvalidPacketException;

public class Opaque<T> {
    public final int length;
    public final T value;

    public Opaque(ByteBuf buffer, Optional<Integer> length, Parser<T> parser) throws InvalidPacketException {
        this.length = length.orElseGet(() -> (int)BufferUtils.uint32((ByteBuf)buffer));
        this.value = parser.parse(BufferUtils.slice((ByteBuf)buffer, (int)this.length));
        BufferUtils.skip((ByteBuf)buffer, (int)((4 - this.length % 4) % 4));
    }

    public Opaque(int length, T t) {
        this.length = length;
        this.value = t;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("length", this.length).add("value", this.value).toString();
    }

    public static <T> T parseUnknown(ByteBuf buffer) throws InvalidPacketException {
        BufferUtils.skip((ByteBuf)buffer, (int)buffer.readableBytes());
        return null;
    }

    public static byte[] parseBytes(ByteBuf buffer) throws InvalidPacketException {
        return BufferUtils.bytes((ByteBuf)buffer, (int)buffer.readableBytes());
    }

    @FunctionalInterface
    public static interface Parser<T> {
        public T parse(ByteBuf var1) throws InvalidPacketException;
    }
}

