/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.utils;

import java.util.regex.Pattern;
import org.owasp.encoder.Encode;
import org.owasp.html.PolicyFactory;
import org.owasp.html.Sanitizers;

public abstract class WebSecurityUtils {
    private static final Pattern ILLEGAL_IN_INTEGER = Pattern.compile("[^0-9+-]");
    private static final Pattern ILLEGAL_IN_FLOAT = Pattern.compile("[^0-9.Ee+-]");
    private static final Pattern ILLEGAL_IN_COLUMN_NAME_PATTERN = Pattern.compile("[^A-Za-z0-9_]");
    private static final PolicyFactory s_sanitizer = Sanitizers.FORMATTING.and(Sanitizers.BLOCKS).and(Sanitizers.IMAGES).and(Sanitizers.LINKS).and(Sanitizers.STYLES).and(Sanitizers.TABLES);

    public static String[] sanitizeString(String[] raw) {
        for (int i = 0; i < raw.length; ++i) {
            raw[i] = WebSecurityUtils.sanitizeString(raw[i]);
        }
        return raw;
    }

    public static String sanitizeString(String raw) {
        return WebSecurityUtils.sanitizeString(raw, false);
    }

    public static String sanitizeString(String raw, boolean allowHTML) {
        if (raw == null || raw.length() == 0) {
            return raw;
        }
        String next = allowHTML ? s_sanitizer.sanitize(raw) : Encode.forHtml((String)raw);
        return next;
    }

    public static int[] safeParseInt(String[] dirty) throws NumberFormatException {
        int[] clean = new int[dirty.length];
        for (int i = 0; i < dirty.length; ++i) {
            String cleanString = ILLEGAL_IN_INTEGER.matcher(dirty[i]).replaceAll("");
            clean[i] = Integer.parseInt(cleanString);
        }
        return clean;
    }

    public static long[] safeParseLong(String[] dirty) throws NumberFormatException {
        long[] clean = new long[dirty.length];
        for (int i = 0; i < dirty.length; ++i) {
            String cleanString = ILLEGAL_IN_INTEGER.matcher(dirty[i]).replaceAll("");
            clean[i] = Long.parseLong(cleanString);
        }
        return clean;
    }

    public static int safeParseInt(String dirty) throws NumberFormatException {
        if (dirty == null) {
            throw new NumberFormatException("String value of integer was null");
        }
        String clean = ILLEGAL_IN_INTEGER.matcher(dirty).replaceAll("");
        return Integer.parseInt(clean);
    }

    public static long safeParseLong(String dirty) throws NumberFormatException {
        if (dirty == null) {
            throw new NumberFormatException("String value of long integer was null");
        }
        String clean = ILLEGAL_IN_INTEGER.matcher(dirty).replaceAll("");
        return Long.parseLong(clean);
    }

    public static float safeParseFloat(String dirty) throws NumberFormatException {
        String clean = ILLEGAL_IN_FLOAT.matcher(dirty).replaceAll("");
        return Float.parseFloat(clean);
    }

    public static double safeParseDouble(String dirty) throws NumberFormatException {
        String clean = ILLEGAL_IN_FLOAT.matcher(dirty).replaceAll("");
        return Double.parseDouble(clean);
    }

    public static String sanitizeDbColumnName(String dirty) {
        return ILLEGAL_IN_COLUMN_NAME_PATTERN.matcher(dirty).replaceAll("");
    }
}

