/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd.shell;

import java.util.List;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.core.logging.Logging;
import org.opennms.netmgt.notifd.api.NotificationConfigProvider;
import org.opennms.netmgt.notifd.api.NotificationTester;
import org.opennms.netmgt.notifd.shell.DestinationPathNameCompleter;

@Command(scope="opennms", name="destination-path-trigger", description="Trigger test notifications to destination path.")
@Service
public class DestinationPathTrigger
implements Action {
    @Argument(name="destinationPath", description="Destination path", required=true)
    @Completion(value=DestinationPathNameCompleter.class)
    String destinationPathName;
    @Option(name="escalate", description="Include escalations when triggering the path.")
    boolean includeEscalations = false;
    @Reference
    public NotificationConfigProvider notificationConfigProvider;
    @Reference
    public NotificationTester notificationTester;

    public Object execute() {
        List targetNames = this.notificationConfigProvider.getTargetNames(this.destinationPathName, this.includeEscalations);
        if (targetNames.isEmpty()) {
            System.out.printf("No path with name '%s' found.\n", this.destinationPathName);
            return null;
        }
        for (String targetName : targetNames) {
            this.triggerTarget(targetName);
        }
        System.out.println("Done triggering targets and commands. See notifd.log for details.");
        return null;
    }

    private void triggerTarget(String targetName) {
        for (String command : this.notificationConfigProvider.getCommands(this.destinationPathName, targetName, this.includeEscalations)) {
            System.out.printf("Triggering command='%s' for target='%s'.\n", command, targetName);
            Logging.MDCCloseable ignored = Logging.withPrefixCloseable((String)"notifd");
            try {
                this.notificationTester.triggerNotificationsForTarget(targetName, command);
            }
            finally {
                if (ignored == null) continue;
                ignored.close();
            }
        }
    }
}

