/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.server;

import java.io.PrintWriter;
import java.io.StringWriter;
import net.jradius.exception.RadiusException;
import net.jradius.log.RadiusLog;
import net.jradius.packet.AccountingRequest;
import net.jradius.packet.PacketFactory;
import net.jradius.packet.RadiusPacket;
import net.jradius.packet.attribute.AttributeList;
import net.jradius.packet.attribute.RadiusAttribute;
import net.jradius.server.JRadiusEvent;
import net.jradius.server.config.Configuration;
import net.jradius.session.JRadiusSession;

public abstract class JRadiusRequest
extends JRadiusEvent {
    private static final long serialVersionUID = 1L;
    private JRadiusSession session;

    public abstract int getReturnValue();

    public abstract void setReturnValue(int var1);

    public abstract AttributeList getConfigItems();

    public abstract RadiusPacket[] getPackets();

    public abstract void setConfigItems(AttributeList var1);

    public abstract void setPackets(RadiusPacket[] var1);

    public JRadiusSession getSession() {
        return this.session;
    }

    public void setSession(JRadiusSession session) {
        this.session = session;
    }

    public String getSessionKey() {
        if (this.session != null) {
            return this.session.getSessionKey();
        }
        return null;
    }

    public RadiusPacket getRequestPacket() throws RadiusException {
        RadiusPacket[] p = this.getPackets();
        if (p.length == 0) {
            throw new RuntimeException("No Request packet in JRadiusRequest");
        }
        return p[0];
    }

    public RadiusPacket getReplyPacket() throws RadiusException {
        RadiusPacket[] p = this.getPackets();
        if (p.length < 2) {
            throw new RadiusException("No Reply packet in JRadiusRequest");
        }
        return p[1];
    }

    public void setReplyPacket(RadiusPacket np) {
        RadiusPacket[] p = this.getPackets();
        if (p[1] != null) {
            PacketFactory.recycle(p[1]);
        }
        p[1] = np;
    }

    public boolean hasReplyPacket() {
        return this.getPackets().length == 2;
    }

    public boolean isAccountingRequest() {
        try {
            return this.getRequestPacket() instanceof AccountingRequest;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void addReplyAttribute(RadiusAttribute a) {
        if (this.hasReplyPacket()) {
            try {
                this.getReplyPacket().addAttribute(a);
            }
            catch (RadiusException radiusException) {}
        } else {
            this.getConfigItems().add(a);
        }
    }

    public void printDebugInfo() {
        if (Configuration.isDebug()) {
            RadiusPacket[] rp = this.getPackets();
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println(">>> packets in request from \"" + this.getSender() + "\":");
            for (int i = 0; i < rp.length; ++i) {
                if (rp[i] == null) continue;
                pw.println("--- packet " + (i + 1) + " of " + rp.length);
                pw.println(rp[i].toString());
            }
            pw.println("Configuration Items:");
            pw.println(this.getConfigItems().toString());
            pw.flush();
            RadiusLog.debug(sw.toString());
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("{");
        sb.append(" requester = ").append(this.getSender());
        sb.append(", type = ").append(this.getTypeString());
        sb.append(" }");
        return sb.toString();
    }
}

