/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.reflect;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.linkedin.util.reflect.ObjectProxy;

public class ObjectProxyInvocationHandler<T>
implements ObjectProxy<T>,
InvocationHandler {
    private final T _proxiedObject;

    public ObjectProxyInvocationHandler(T proxiedObject) {
        this._proxiedObject = proxiedObject;
    }

    @Override
    public T getProxiedObject() {
        return this._proxiedObject;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            return method.invoke(this._proxiedObject, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public static <T> T createProxy(Class<T> interfaceToProxy, T objectToProxy) {
        return (T)Proxy.newProxyInstance(interfaceToProxy.getClassLoader(), new Class[]{interfaceToProxy}, new ObjectProxyInvocationHandler<T>(objectToProxy));
    }
}

