/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.sample.health;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import org.opennms.integration.api.sample.SampleCollector;
import org.opennms.integration.api.sample.SamplePoller;
import org.opennms.integration.api.v1.collectors.CollectionRequest;
import org.opennms.integration.api.v1.collectors.CollectionSet;
import org.opennms.integration.api.v1.collectors.ServiceCollectorClient;
import org.opennms.integration.api.v1.dao.NodeDao;
import org.opennms.integration.api.v1.detectors.DetectorClient;
import org.opennms.integration.api.v1.health.Context;
import org.opennms.integration.api.v1.health.HealthCheck;
import org.opennms.integration.api.v1.health.Response;
import org.opennms.integration.api.v1.health.Status;
import org.opennms.integration.api.v1.health.immutables.ImmutableResponse;
import org.opennms.integration.api.v1.model.IpInterface;
import org.opennms.integration.api.v1.model.Node;
import org.opennms.integration.api.v1.pollers.PollerResult;
import org.opennms.integration.api.v1.pollers.ServicePollerClient;

public class ServiceExtensionHealthCheck
implements HealthCheck {
    private final DetectorClient detectorClient;
    private final ServicePollerClient pollerClient;
    private final ServiceCollectorClient collectorClient;
    private final NodeDao nodeDao;

    public ServiceExtensionHealthCheck(DetectorClient detectorClient, ServicePollerClient pollerClient, ServiceCollectorClient collectorClient, NodeDao nodeDao) {
        this.detectorClient = Objects.requireNonNull(detectorClient);
        this.pollerClient = Objects.requireNonNull(pollerClient);
        this.collectorClient = Objects.requireNonNull(collectorClient);
        this.nodeDao = Objects.requireNonNull(nodeDao);
    }

    public String getDescription() {
        return "OIA :: Sample Project :: Service Extensions";
    }

    public Response perform(Context context) {
        return this.verifyExtensionsAtLocation(this.nodeDao.getDefaultLocationName());
    }

    protected Response verifyExtensionsAtLocation(String location) {
        block12: {
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("username", "admin");
            attributes.put("password", "admin");
            CompletableFuture future = this.detectorClient.detect("Sample", "localhost", location, attributes);
            try {
                if (!((Boolean)future.get()).booleanValue()) {
                    return ImmutableResponse.newInstance((Status)Status.Failure, (String)"Sample Detector detection failed");
                }
            }
            catch (Exception e) {
                return ImmutableResponse.newInstance((Exception)e);
            }
            try {
                CompletableFuture pollerStatus = this.pollerClient.poll().withLocation(location).withAddress(InetAddress.getLocalHost()).withPollerClassName(SamplePoller.class.getCanonicalName()).withServiceName("Sample").execute();
                if (!((PollerResult)pollerStatus.get()).getStatus().equals((Object)org.opennms.integration.api.v1.pollers.Status.Up)) {
                    return ImmutableResponse.newInstance((Status)Status.Failure, (String)((PollerResult)pollerStatus.get()).getReason());
                }
                int hashOfLocationName = ((Number)((PollerResult)pollerStatus.get()).getProperties().get("location")).intValue();
                if (Objects.hash(location) != hashOfLocationName) {
                    return ImmutableResponse.newInstance((Status)Status.Failure, (String)String.format("Expected location hash %d, but got %d instead.", Objects.hash(location), hashOfLocationName));
                }
            }
            catch (Exception e) {
                return ImmutableResponse.newInstance((Exception)e);
            }
            Optional<Node> node = this.getFirstNodeWithInterfaceAtLocation(location);
            if (!node.isPresent()) {
                return ImmutableResponse.newInstance((Status)Status.Success);
            }
            try {
                double magicNumber = new Random().nextDouble();
                CompletableFuture collectionSetFuture = this.collectorClient.collect().withCollectorClassName(SampleCollector.class.getCanonicalName()).withRequest((CollectionRequest)new SampleCollector.CollectionRequestImpl(node.get().getId(), ((IpInterface)node.get().getIpInterfaces().get(0)).getIpAddress())).withAttribute("magicNumber", (Object)magicNumber).execute();
                CollectionSet collectionResult = (CollectionSet)collectionSetFuture.get();
                if (collectionResult.getStatus().equals((Object)CollectionSet.Status.SUCCEEDED)) {
                    if (!SampleCollector.validateCollectionSet(collectionResult, node.get().getId(), magicNumber, location)) {
                        return ImmutableResponse.newInstance((Status)Status.Failure, (String)"Collection set didn't match");
                    }
                    break block12;
                }
                return ImmutableResponse.newInstance((Status)Status.Failure, (String)"Sample Collector Collection Failed");
            }
            catch (Exception e) {
                return ImmutableResponse.newInstance((Exception)e);
            }
        }
        return ImmutableResponse.newInstance((Status)Status.Success, (String)("Extensions verified at location " + location));
    }

    private Optional<Node> getFirstNodeWithInterfaceAtLocation(String location) {
        return this.nodeDao.getNodesInLocation(location).stream().filter(n -> !n.getIpInterfaces().isEmpty()).findFirst();
    }

    protected NodeDao getNodeDao() {
        return this.nodeDao;
    }
}

