/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.sample.health;

import java.util.Objects;
import org.opennms.integration.api.v1.health.Context;
import org.opennms.integration.api.v1.health.HealthCheck;
import org.opennms.integration.api.v1.health.Response;
import org.opennms.integration.api.v1.health.Status;
import org.opennms.integration.api.v1.health.immutables.ImmutableResponse;
import org.opennms.integration.api.v1.runtime.Container;
import org.opennms.integration.api.v1.runtime.RuntimeInfo;

public class MinionHealthCheck
implements HealthCheck {
    private final RuntimeInfo runtimeInfo;

    public MinionHealthCheck(RuntimeInfo runtimeInfo) {
        this.runtimeInfo = Objects.requireNonNull(runtimeInfo);
    }

    public String getDescription() {
        return "OIA :: Sample Project :: Minion";
    }

    public Response perform(Context context) {
        if (Container.MINION.equals((Object)this.runtimeInfo.getContainer())) {
            return ImmutableResponse.newInstance((Status)Status.Success);
        }
        return ImmutableResponse.newInstance((Status)Status.Failure, (String)("Expected Minion container, but got: " + this.runtimeInfo.getContainer()));
    }
}

