/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.specs.locator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class OsgiLocator {
    public static final long DEFAULT_TIMEOUT = 0L;
    public static final String TIMEOUT = "org.apache.karaf.specs.timeout";
    private static final Map<String, List<Callable<Class>>> FACTORIES = new HashMap<String, List<Callable<Class>>>();
    private static final ReadWriteLock LOCK = new ReentrantReadWriteLock();

    private OsgiLocator() {
    }

    public static void unregister(String id, Callable<Class> factory) {
        LOCK.writeLock().lock();
        try {
            List<Callable<Class>> l = FACTORIES.get(id);
            if (l != null) {
                l.remove(factory);
            }
        }
        finally {
            LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(String id, Callable<Class> factory) {
        LOCK.writeLock().lock();
        try {
            FACTORIES.computeIfAbsent(id, k -> new ArrayList()).add(0, factory);
            ReadWriteLock readWriteLock = LOCK;
            synchronized (readWriteLock) {
                LOCK.notifyAll();
            }
        }
        finally {
            LOCK.writeLock().unlock();
        }
    }

    public static <T> Class<T> locate(Class<T> factoryId) {
        return OsgiLocator.locate(factoryId, factoryId.getName());
    }

    private static long getTimeout() {
        long timeout = 0L;
        try {
            String prop = System.getProperty(TIMEOUT);
            if (prop != null) {
                timeout = Long.parseLong(prop);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Class<T> locate(Class<T> factoryClass, String factoryId) {
        long t0;
        long timeout = OsgiLocator.getTimeout();
        if (timeout <= 0L) {
            return OsgiLocator.doLocate(factoryClass, factoryId);
        }
        long t1 = t0 = System.currentTimeMillis();
        while (t1 - t0 < timeout) {
            Class<T> impl = OsgiLocator.doLocate(factoryClass, factoryId);
            if (impl != null) {
                return impl;
            }
            ReadWriteLock readWriteLock = LOCK;
            synchronized (readWriteLock) {
                try {
                    LOCK.wait(timeout - (t1 - t0));
                }
                catch (InterruptedException e) {
                    return null;
                }
            }
            t1 = System.currentTimeMillis();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> Class<T> doLocate(Class<T> factoryClass, String factoryId) {
        LOCK.readLock().lock();
        try {
            List<Callable<Class>> l = FACTORIES.get(factoryId);
            if (l != null && !l.isEmpty()) {
                String factoryClassName = System.getProperty(factoryId);
                try {
                    for (Callable<Class> i : l) {
                        Class c = null;
                        try {
                            c = i.call();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (c == null || factoryClass != c.getClassLoader().loadClass(factoryClass.getName()) || factoryClassName != null && !c.getName().equals(factoryClassName)) continue;
                        Class clazz = c;
                        return clazz;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Class<T> clazz = null;
            return clazz;
        }
        finally {
            LOCK.readLock().unlock();
        }
    }

    public static <T> List<Class<? extends T>> locateAll(Class<T> factoryId) {
        return OsgiLocator.locateAll(factoryId, factoryId.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<Class<? extends T>> locateAll(Class<T> factoryClass, String factoryId) {
        LOCK.readLock().lock();
        try {
            ArrayList<Class> classes = new ArrayList<Class>();
            List<Callable<Class>> l = FACTORIES.get(factoryId);
            if (l != null) {
                for (Callable callable : l) {
                    try {
                        Class c = (Class)callable.call();
                        if (c == null || !factoryClass.isAssignableFrom(c)) continue;
                        classes.add(c);
                    }
                    catch (Exception exception) {}
                }
            }
            ArrayList<Class> arrayList = classes;
            return arrayList;
        }
        finally {
            LOCK.readLock().unlock();
        }
    }
}

