/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.xa;

import java.io.PrintWriter;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class LoggingXAResource
implements XAResource {
    private PrintWriter writer_;
    private XAResource xares_;

    public LoggingXAResource(XAResource xares, PrintWriter writer) {
        this.xares_ = xares;
        this.writer_ = writer;
    }

    private void log(String msg, XAException error) {
        if (this.writer_ != null) {
            this.writer_.println("XAResource: " + msg + ": " + error.toString() + " errorCode " + error.errorCode);
        }
    }

    private void log(String msg) {
        if (this.writer_ != null) {
            this.writer_.println("XAResource: " + msg);
        }
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        Xid[] ret = null;
        try {
            this.log("Enter recover");
            ret = this.xares_.recover(flag);
            this.log("Exit recover");
        }
        catch (XAException e) {
            this.log("Error in recover", e);
            throw e;
        }
        return ret;
    }

    @Override
    public boolean setTransactionTimeout(int secs) throws XAException {
        boolean ret = false;
        try {
            this.log("Enter setTransactionTimeout");
            ret = this.xares_.setTransactionTimeout(secs);
            this.log("Exit setTransactionTimeout with return value " + ret);
        }
        catch (XAException e) {
            this.log("Error in setTransactionTimeout", e);
            throw e;
        }
        return ret;
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        int ret = -1;
        try {
            this.log("Enter getTransactionTimeout");
            ret = this.xares_.getTransactionTimeout();
            this.log("Exit getTransactionTimeout with return value " + ret);
        }
        catch (XAException e) {
            this.log("Error in getTransactionTimeout", e);
            throw e;
        }
        return ret;
    }

    @Override
    public boolean isSameRM(XAResource xares) throws XAException {
        boolean ret = false;
        try {
            this.log("Enter isSameRM");
            ret = this.xares_.isSameRM(xares);
            this.log("Exit isSameRM with return value " + ret);
        }
        catch (XAException e) {
            this.log("Error in isSameRM", e);
            throw e;
        }
        return ret;
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        try {
            this.log("Enter start for xid " + xid.toString());
            this.xares_.start(xid, flags);
            this.log("Exit start");
        }
        catch (XAException e) {
            this.log("Error in start", e);
            throw e;
        }
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        try {
            this.log("Enter end for xid " + xid.toString());
            this.xares_.end(xid, flags);
            this.log("Exit end");
        }
        catch (XAException e) {
            this.log("Error in end", e);
            throw e;
        }
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        int ret = -1;
        try {
            this.log("Enter prepare for xid " + xid.toString());
            ret = this.xares_.prepare(xid);
            this.log("Exit prepare with return value " + ret);
        }
        catch (XAException e) {
            this.log("Error in prepare", e);
            throw e;
        }
        return ret;
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        try {
            this.log("Enter rollback for xid " + xid.toString());
            this.xares_.rollback(xid);
            this.log("Exit rollback");
        }
        catch (XAException e) {
            this.log("Error in rollback", e);
            throw e;
        }
    }

    @Override
    public void commit(Xid xid, boolean onephase) throws XAException {
        try {
            this.log("Enter commit for xid " + xid.toString());
            this.xares_.commit(xid, onephase);
            this.log("Exit commit");
        }
        catch (XAException e) {
            this.log("Error in commit", e);
            throw e;
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        try {
            this.log("Enter forget for xid " + xid.toString());
            this.xares_.forget(xid);
            this.log("Exit forget");
        }
        catch (XAException e) {
            this.log("Error in forget", e);
            throw e;
        }
    }
}

