/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.simple.response;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrivialTimeResponse {
    private static final Logger LOG = LoggerFactory.getLogger(TrivialTimeResponse.class);
    boolean available = false;

    public TrivialTimeResponse() {
    }

    public TrivialTimeResponse(int remoteTime, int localTime, int allowedSkew) {
        LOG.debug("qualifyTime: checking remote time {} against local time {} with max skew of {}", new Object[]{remoteTime, localTime, allowedSkew});
        if (localTime - remoteTime > allowedSkew || remoteTime - localTime > allowedSkew) {
            if (localTime > remoteTime) {
                LOG.debug("Remote time is {} seconds slow", (Object)(localTime - remoteTime));
            } else {
                LOG.debug("Remote time is {} seconds fast", (Object)(remoteTime - localTime));
            }
        }
        if (localTime > remoteTime && localTime - remoteTime > allowedSkew) {
            LOG.debug("Remote time is {} seconds behind local, more than the allowable {}", (Object)(localTime - remoteTime), (Object)allowedSkew);
        } else if (remoteTime > localTime && remoteTime - localTime > allowedSkew) {
            LOG.debug("Remote time is {} seconds ahead of local, more than the allowable {}", (Object)(remoteTime - localTime), (Object)allowedSkew);
        } else {
            this.available = true;
        }
    }

    public boolean isAvailable() {
        return this.available;
    }
}

