/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.icmp.proxy;

import java.net.InetAddress;
import javax.annotation.PostConstruct;
import org.opennms.core.rpc.api.RpcClient;
import org.opennms.core.rpc.api.RpcClientFactory;
import org.opennms.core.rpc.api.RpcModule;
import org.opennms.netmgt.icmp.proxy.LocationAwarePingClient;
import org.opennms.netmgt.icmp.proxy.PingProxyRpcModule;
import org.opennms.netmgt.icmp.proxy.PingRequestBuilder;
import org.opennms.netmgt.icmp.proxy.PingRequestBuilderImpl;
import org.opennms.netmgt.icmp.proxy.PingRequestDTO;
import org.opennms.netmgt.icmp.proxy.PingResponseDTO;
import org.opennms.netmgt.icmp.proxy.PingSweepRequestBuilder;
import org.opennms.netmgt.icmp.proxy.PingSweepRequestBuilderImpl;
import org.opennms.netmgt.icmp.proxy.PingSweepRequestDTO;
import org.opennms.netmgt.icmp.proxy.PingSweepResponseDTO;
import org.opennms.netmgt.icmp.proxy.PingSweepRpcModule;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="locationAwarePingClient")
public class LocationAwarePingClientImpl
implements LocationAwarePingClient {
    @Autowired
    private RpcClientFactory rpcClientFactory;
    @Autowired
    private PingProxyRpcModule pingProxyRpcModule;
    @Autowired
    private PingSweepRpcModule pingSweepRpcModule;
    private RpcClient<PingRequestDTO, PingResponseDTO> pingProxyDelegate;
    private RpcClient<PingSweepRequestDTO, PingSweepResponseDTO> pingSweepDelegate;

    @PostConstruct
    public void init() {
        this.pingProxyDelegate = this.rpcClientFactory.getClient((RpcModule)this.pingProxyRpcModule);
        this.pingSweepDelegate = this.rpcClientFactory.getClient((RpcModule)this.pingSweepRpcModule);
    }

    @Override
    public PingRequestBuilder ping(InetAddress inetAddress) {
        return new PingRequestBuilderImpl(this.pingProxyDelegate).withInetAddress(inetAddress);
    }

    @Override
    public PingSweepRequestBuilder sweep() {
        return new PingSweepRequestBuilderImpl(this.pingSweepDelegate);
    }
}

