/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.whitelist;

import com.atlassian.oai.validator.model.ApiOperation;
import com.atlassian.oai.validator.model.Request;
import com.atlassian.oai.validator.model.Response;
import com.atlassian.oai.validator.report.ValidationReport;
import com.atlassian.oai.validator.whitelist.NamedWhitelistRule;
import com.atlassian.oai.validator.whitelist.rule.WhitelistRule;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class ValidationErrorsWhitelist {
    private final List<NamedWhitelistRule> rules;

    public static ValidationErrorsWhitelist create() {
        return new ValidationErrorsWhitelist(Collections.emptyList());
    }

    public ValidationErrorsWhitelist withRule(String title, WhitelistRule rule) {
        return new ValidationErrorsWhitelist((Iterable<NamedWhitelistRule>)ImmutableList.builder().addAll(this.rules).add((Object)new NamedWhitelistRule(title, rule)).build());
    }

    public Optional<NamedWhitelistRule> whitelistedBy(ValidationReport.Message message, @Nullable ApiOperation operation, @Nullable Request request, @Nullable Response response) {
        return this.rules.stream().filter(rule -> rule.getRule().matches(message, operation, request, response)).findFirst();
    }

    private ValidationErrorsWhitelist(Iterable<NamedWhitelistRule> rules) {
        this.rules = ImmutableList.copyOf(rules);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidationErrorsWhitelist that = (ValidationErrorsWhitelist)o;
        return Objects.equals(this.rules, that.rules);
    }

    public int hashCode() {
        return Objects.hash(this.rules);
    }

    public String toString() {
        return this.rules.toString();
    }
}

