/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.model;

import com.atlassian.oai.validator.model.Body;
import com.atlassian.oai.validator.model.ByteArrayBody;
import com.atlassian.oai.validator.model.InputStreamBody;
import com.atlassian.oai.validator.model.Response;
import com.atlassian.oai.validator.model.SimpleRequest;
import com.atlassian.oai.validator.model.StringBody;
import com.atlassian.oai.validator.util.ContentTypeUtils;
import com.google.common.collect.Multimap;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SimpleResponse
implements Response {
    private final int status;
    private final Map<String, Collection<String>> headers;
    private final Optional<Body> responseBody;

    private SimpleResponse(int status, @Nonnull Map<String, Collection<String>> headers, @Nullable Body body) {
        this.status = status;
        this.headers = Objects.requireNonNull(headers);
        this.responseBody = Optional.ofNullable(body);
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    @Nonnull
    public Optional<String> getBody() {
        return Optional.empty();
    }

    @Override
    @Nonnull
    public Optional<Body> getResponseBody() {
        return this.responseBody;
    }

    @Override
    @Nonnull
    public Collection<String> getHeaderValues(String name) {
        return SimpleRequest.getFromMapOrEmptyList(this.headers, name);
    }

    public static class Builder {
        private final int status;
        private final Multimap<String, String> headers;
        private Body body;
        private String bodyAsStringFallback;

        public static Builder status(int status) {
            return new Builder(status);
        }

        public static Builder ok() {
            return new Builder(200);
        }

        public static Builder noContent() {
            return new Builder(204);
        }

        public static Builder badRequest() {
            return new Builder(400);
        }

        public static Builder unauthorized() {
            return new Builder(401);
        }

        public static Builder notFound() {
            return new Builder(404);
        }

        public static Builder serverError() {
            return new Builder(500);
        }

        public Builder(int status) {
            this.status = status;
            this.headers = SimpleRequest.Builder.multimapBuilder(false);
        }

        public Builder withBody(String content) {
            this.bodyAsStringFallback = content;
            return this;
        }

        public Builder withBody(String content, Charset charset) {
            if (content != null && charset != null) {
                this.body = new StringBody(content, charset);
                return this;
            }
            return this.withBody(content);
        }

        public Builder withBody(byte[] content) {
            this.body = content != null ? new ByteArrayBody(content) : null;
            return this;
        }

        public Builder withBody(InputStream content) {
            this.body = content != null ? new InputStreamBody(content) : null;
            return this;
        }

        public Builder withHeader(String name, List<String> values) {
            SimpleRequest.Builder.putValuesToMapOrDefault(this.headers, name, values, "");
            return this;
        }

        public Builder withHeader(String name, String ... values) {
            return this.withHeader(name, Arrays.asList(values));
        }

        public Builder withContentType(String contentType) {
            return this.withHeader("Content-Type", contentType);
        }

        public SimpleResponse build() {
            if (this.body == null && this.bodyAsStringFallback != null) {
                Charset charset = ContentTypeUtils.getCharsetFromContentType(this.headers).orElse(StandardCharsets.UTF_8);
                this.body = new StringBody(this.bodyAsStringFallback, charset);
            }
            return new SimpleResponse(this.status, this.headers.asMap(), this.body);
        }
    }
}

