/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.jdbc;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.opennms.netmgt.config.jdbc.JdbcDataCollection;
import org.opennms.netmgt.config.jdbc.JdbcRrd;
import org.opennms.netmgt.rrd.RrdRepository;

@XmlRootElement(name="jdbc-datacollection-config")
public class JdbcDataCollectionConfig
implements Serializable,
Comparable<JdbcDataCollectionConfig> {
    private static final long serialVersionUID = -7884808717236892997L;
    private static final JdbcDataCollection[] OF_DATA_COLLECTIONS = new JdbcDataCollection[0];
    @XmlElement(name="jdbc-collection")
    private List<JdbcDataCollection> m_jdbcDataCollections = new ArrayList<JdbcDataCollection>();
    @XmlAttribute(name="rrdRepository")
    private String m_rrdRepository;

    @XmlTransient
    public List<JdbcDataCollection> getJdbcDataCollections() {
        return this.m_jdbcDataCollections;
    }

    public void setJdbcDataCollections(List<JdbcDataCollection> jdbcDataCollections) {
        this.m_jdbcDataCollections = jdbcDataCollections;
    }

    @XmlTransient
    public String getRrdRepository() {
        return this.m_rrdRepository;
    }

    public void setRrdRepository(String rrdRepository) {
        this.m_rrdRepository = rrdRepository;
    }

    public void addDataCollection(JdbcDataCollection dataCollection) {
        this.m_jdbcDataCollections.add(dataCollection);
    }

    public void removeDataCollection(JdbcDataCollection dataCollection) {
        this.m_jdbcDataCollections.remove(dataCollection);
    }

    public void removeDataCollectionByName(String name) {
        for (JdbcDataCollection dataCollection : this.m_jdbcDataCollections) {
            if (!dataCollection.getName().equals(name)) continue;
            this.m_jdbcDataCollections.remove(dataCollection);
            return;
        }
    }

    public JdbcDataCollection getDataCollectionByName(String name) {
        for (JdbcDataCollection dataCol : this.m_jdbcDataCollections) {
            if (!dataCol.getName().equals(name)) continue;
            return dataCol;
        }
        return null;
    }

    public JdbcDataCollectionConfig merge(JdbcDataCollectionConfig other) {
        if (other == null) {
            return this;
        }
        if (this.m_rrdRepository == null && other.m_rrdRepository != null) {
            this.m_rrdRepository = other.m_rrdRepository;
        }
        this.getCollection().addAll(other.getCollection());
        return this;
    }

    public List<JdbcDataCollection> getCollection() {
        if (this.m_jdbcDataCollections == null) {
            this.m_jdbcDataCollections = new ArrayList<JdbcDataCollection>();
        }
        return this.m_jdbcDataCollections;
    }

    public RrdRepository buildRrdRepository(String collectionName) {
        JdbcRrd rrd = this.getDataCollectionByName(collectionName).getJdbcRrd();
        RrdRepository repo = new RrdRepository();
        repo.setRrdBaseDir(new File(this.getRrdRepository()));
        repo.setRraList(rrd.getJdbcRras());
        repo.setStep(rrd.getStep().intValue());
        repo.setHeartBeat(2 * rrd.getStep());
        return repo;
    }

    @Override
    public int compareTo(JdbcDataCollectionConfig obj) {
        return new CompareToBuilder().append((Object)this.getRrdRepository(), (Object)obj.getRrdRepository()).append((Object[])this.getJdbcDataCollections().toArray(OF_DATA_COLLECTIONS), (Object[])obj.getJdbcDataCollections().toArray(OF_DATA_COLLECTIONS)).toComparison();
    }

    public boolean equals(Object obj) {
        if (obj instanceof JdbcDataCollectionConfig) {
            JdbcDataCollectionConfig other = (JdbcDataCollectionConfig)obj;
            return new EqualsBuilder().append((Object)this.getRrdRepository(), (Object)other.getRrdRepository()).append((Object[])this.getJdbcDataCollections().toArray(OF_DATA_COLLECTIONS), (Object[])other.getJdbcDataCollections().toArray(OF_DATA_COLLECTIONS)).isEquals();
        }
        return false;
    }
}

