/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.grpc.exporter.mapper;

import java.util.List;
import java.util.Map;
import org.mapstruct.CollectionMappingStrategy;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.Named;
import org.mapstruct.NullValueCheckStrategy;
import org.mapstruct.factory.Mappers;
import org.opennms.features.grpc.exporter.mapper.MonitoredServiceWithMetadata;
import org.opennms.integration.api.v1.runtime.RuntimeInfo;
import org.opennms.plugin.grpc.proto.services.InventoryUpdateList;
import org.opennms.plugin.grpc.proto.services.ServiceComponent;
import org.opennms.plugin.grpc.proto.services.StateUpdate;
import org.opennms.plugin.grpc.proto.services.StateUpdateList;

@Mapper(collectionMappingStrategy=CollectionMappingStrategy.ADDER_PREFERRED, nullValueCheckStrategy=NullValueCheckStrategy.ALWAYS)
public interface MonitoredServiceMapper {
    public static final MonitoredServiceMapper INSTANCE = (MonitoredServiceMapper)Mappers.getMapper(MonitoredServiceMapper.class);

    @Named(value="foreignService")
    default public String foreignService(MonitoredServiceWithMetadata service) {
        return String.format("%s/%s/%s/%s", service.getNode().getForeignSource(), service.getNode().getForeignId(), service.getIface().getIpAddress().getHostAddress(), service.getMonitoredService().getName());
    }

    @Named(value="displayName")
    default public String displayName(MonitoredServiceWithMetadata service) {
        return String.format("%s %s %s", service.getNode().getLabel(), service.getIface().getIpAddress().getHostAddress(), service.getMonitoredService().getName());
    }

    @Named(value="attributes")
    default public Map<String, String> attributes(MonitoredServiceWithMetadata service) {
        return Map.ofEntries(Map.entry("nodeId", Integer.toString(service.getNode().getId())), Map.entry("nodeLabel", service.getNode().getLabel()), Map.entry("location", service.getNode().getLocation()), Map.entry("nodeCriteria", String.format("%s:%s", service.getNode().getForeignSource(), service.getNode().getForeignId())), Map.entry("ipAddress", service.getIface().getIpAddress().getHostAddress()), Map.entry("serviceName", service.getMonitoredService().getName()));
    }

    @Mappings(value={@Mapping(target="foreignService", source="service", qualifiedByName={"foreignService"}), @Mapping(target="name", source="service", qualifiedByName={"displayName"}), @Mapping(target="healthy", source="service.monitoredService.status"), @Mapping(target="attributes", source="service", qualifiedByName={"attributes"}), @Mapping(target="tags", source="service.node.categories")})
    public ServiceComponent toInventoryUpdate(MonitoredServiceWithMetadata var1);

    @Mappings(value={@Mapping(target="foreignType", constant="OpenNMS"), @Mapping(target="foreignSource", source="runtimeInfo.systemId"), @Mapping(target="services", source="services"), @Mapping(target="snapshot", source="snapshot")})
    public InventoryUpdateList toInventoryUpdates(List<MonitoredServiceWithMetadata> var1, RuntimeInfo var2, boolean var3);

    @Mappings(value={@Mapping(target="foreignService", source="service", qualifiedByName={"foreignService"}), @Mapping(target="healthy", source="service.monitoredService.status")})
    public StateUpdate toStateUpdate(MonitoredServiceWithMetadata var1);

    @Mappings(value={@Mapping(target="foreignType", constant="OpenNMS"), @Mapping(target="foreignSource", source="runtimeInfo.systemId"), @Mapping(target="updates", source="updates")})
    public StateUpdateList toStateUpdates(List<MonitoredServiceWithMetadata> var1, RuntimeInfo var2);
}

