/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.grpc.exporter.bsm;

import com.google.protobuf.Empty;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ConnectivityState;
import io.grpc.stub.StreamObserver;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLException;
import org.opennms.features.grpc.exporter.Callback;
import org.opennms.features.grpc.exporter.GrpcClient;
import org.opennms.features.grpc.exporter.NamedThreadFactory;
import org.opennms.plugin.grpc.proto.services.HeartBeat;
import org.opennms.plugin.grpc.proto.services.InventoryUpdateList;
import org.opennms.plugin.grpc.proto.services.ServiceSyncGrpc;
import org.opennms.plugin.grpc.proto.services.StateUpdateList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BsmGrpcClient
extends GrpcClient {
    private static final Logger LOG = LoggerFactory.getLogger(BsmGrpcClient.class);
    public static final String FOREIGN_TYPE = "OpenNMS";
    private ServiceSyncGrpc.ServiceSyncStub monitoredServiceSyncStub;
    private StreamObserver<InventoryUpdateList> inventoryUpdateStream;
    private StreamObserver<StateUpdateList> stateUpdateStream;
    private StreamObserver<HeartBeat> heartBeatStream;
    private ScheduledExecutorService scheduler;
    private final AtomicBoolean reconnecting = new AtomicBoolean(false);
    private Callback inventoryCallback;
    private boolean enabled = true;

    public BsmGrpcClient(String host, String tlsCertPath, boolean tlsEnabled, ClientInterceptor clientInterceptor) {
        super(host, tlsCertPath, tlsEnabled, clientInterceptor);
        this.scheduler = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("grpc-exporter-connect"));
    }

    public void start() throws SSLException {
        if (!this.enabled) {
            LOG.info("BSM GrpcExporterClient disabled, not starting connections to {}", (Object)super.getHost());
            return;
        }
        super.startGrpcConnection();
        this.monitoredServiceSyncStub = ServiceSyncGrpc.newStub((Channel)super.getChannel());
        this.connectStreams();
        LOG.info("BSM GrpcExporterClient started to {}", (Object)super.getHost());
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void stop() {
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
        }
        super.stopGrpcConnection();
        LOG.info("BSM GrpcExporterClient stopped for {}", (Object)super.getHost());
    }

    public void setInventoryCallback(Callback inventoryCallback) {
        this.inventoryCallback = inventoryCallback;
    }

    private synchronized void initializeStreams() {
        if (super.getChannelState().equals((Object)ConnectivityState.READY)) {
            try {
                this.inventoryUpdateStream = this.monitoredServiceSyncStub.inventoryUpdate(new LoggingAckReceiver("bsm_monitored_service_inventory_update", this));
                this.stateUpdateStream = this.monitoredServiceSyncStub.stateUpdate(new LoggingAckReceiver("bsm_monitored_service_state_update", this));
                this.heartBeatStream = this.monitoredServiceSyncStub.heartBeatUpdate(new LoggingAckReceiver("bsm_heartbeat_update", this));
                this.scheduler.shutdown();
                this.scheduler = null;
                LOG.info("BSM Streams initialized successfully.");
                this.reconnecting.set(false);
                if (this.inventoryCallback != null) {
                    this.inventoryCallback.sendInventorySnapShot();
                }
            }
            catch (Exception e) {
                LOG.error("Failed to initialize streams", (Throwable)e);
            }
        } else {
            LOG.info("Channel state is not READY, retrying...");
        }
    }

    private void connectStreams() {
        this.scheduler.scheduleAtFixedRate(this::initializeStreams, 30L, 30L, TimeUnit.SECONDS);
    }

    private synchronized void reconnectStreams() {
        if (this.reconnecting.compareAndSet(false, true) && !super.getStopped() && (this.scheduler == null || this.scheduler.isShutdown())) {
            this.scheduler = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("grpc-exporter-reconnect"));
            this.scheduler.scheduleAtFixedRate(this::initializeStreams, 30L, 30L, TimeUnit.SECONDS);
        }
    }

    public void sendMonitoredServicesInventoryUpdate(InventoryUpdateList inventoryUpdates) {
        if (this.inventoryUpdateStream != null) {
            this.inventoryUpdateStream.onNext((Object)inventoryUpdates);
            LOG.info("Sent an monitored service inventory update with {} services", (Object)inventoryUpdates.getServicesCount());
        } else {
            LOG.warn("Unable to send inventory snapshot since channel is not ready yet");
        }
    }

    public void sendMonitoredServicesStatusUpdate(StateUpdateList stateUpdates) {
        if (this.stateUpdateStream != null) {
            this.stateUpdateStream.onNext((Object)stateUpdates);
            LOG.info("BSM-Sent an monitored service state update with {} services", (Object)stateUpdates.getUpdatesCount());
        } else {
            LOG.warn("BSM-Unable to send monitored service status update since channel is not ready yet");
        }
    }

    public void sendHeartBeatUpdate(HeartBeat heartBeat) {
        if (this.heartBeatStream != null) {
            this.heartBeatStream.onNext((Object)heartBeat);
        } else {
            LOG.warn("BSM-Unable to send heartbeat status update since channel is not ready yet");
        }
    }

    private static class LoggingAckReceiver
    implements StreamObserver<Empty> {
        private final String type;
        private final BsmGrpcClient client;

        private LoggingAckReceiver(String type, BsmGrpcClient client) {
            this.type = Objects.requireNonNull(type);
            this.client = client;
        }

        public void onNext(Empty value) {
            LOG.debug("BSM gRPC Client : Received ACK {}", (Object)this.type);
        }

        public void onError(Throwable t) {
            LOG.error("BSM gRPC Client : Received error {}", (Object)this.type, (Object)t);
            this.client.reconnectStreams();
        }

        public void onCompleted() {
            LOG.info("BSM gRPC Client : Completed {}", (Object)this.type);
            this.client.reconnectStreams();
        }
    }
}

