/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision;

import com.atomikos.beans.PropertyException;
import com.atomikos.beans.PropertyUtils;
import com.google.common.base.Strings;
import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.exception.GeoIp2Exception;
import com.maxmind.geoip2.model.CityResponse;
import inet.ipaddr.IPAddressString;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.Optional;
import java.util.Set;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.geoip.Asset;
import org.opennms.netmgt.config.geoip.GeoIpConfig;
import org.opennms.netmgt.config.geoip.GeoIpConfigDao;
import org.opennms.netmgt.config.geoip.Location;
import org.opennms.netmgt.config.geoip.Subnet;
import org.opennms.netmgt.dao.api.AssetRecordDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.events.api.annotations.EventHandler;
import org.opennms.netmgt.events.api.annotations.EventListener;
import org.opennms.netmgt.events.api.model.IEvent;
import org.opennms.netmgt.events.api.model.IParm;
import org.opennms.netmgt.model.OnmsAssetRecord;
import org.opennms.netmgt.model.OnmsGeolocation;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.provision.ProvisioningAdapterException;
import org.opennms.netmgt.provision.SimplerQueuedProvisioningAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

@EventListener(name="GeoIpProvisioningAdapter")
public class GeoIpProvisioningAdapter
extends SimplerQueuedProvisioningAdapter
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(GeoIpProvisioningAdapter.class);
    public static final String PREFIX = "Provisiond.";
    public static final String NAME = "GeoIpProvisioningAdapter";
    private NodeDao nodeDao;
    private EventForwarder eventForwarder;
    private GeoIpConfigDao geoIpConfigDao;
    private DatabaseReader databaseReader;
    private AssetRecordDao assetRecordDao;

    public GeoIpProvisioningAdapter() {
        super(NAME);
    }

    private DatabaseReader getDatabaseReader() throws IOException {
        if (this.databaseReader == null) {
            GeoIpConfig geoIpConfig = (GeoIpConfig)this.geoIpConfigDao.getContainer().getObject();
            this.databaseReader = new DatabaseReader.Builder(new File(geoIpConfig.getDatabase())).build();
        }
        return this.databaseReader;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.nodeDao, (String)"Node DAO must not be null");
        Assert.notNull((Object)this.assetRecordDao, (String)"Asset Record DAO must not be null");
        Assert.notNull((Object)this.eventForwarder, (String)"Event Forwarder must not be null");
        Assert.notNull((Object)((Object)this.geoIpConfigDao), (String)"GeoIp Configuration DAO must not be null");
    }

    @Override
    public void doAddNode(int nodeId) throws ProvisioningAdapterException {
        this.queryNode(nodeId);
    }

    @Override
    public void doUpdateNode(int nodeId) throws ProvisioningAdapterException {
        this.queryNode(nodeId);
    }

    protected boolean isPublicAddress(InetAddress address) {
        boolean isUla = address.getAddress().length == 16 ? (address.getAddress()[0] & 0xFE) == 252 : false;
        return !address.isSiteLocalAddress() && !address.isAnyLocalAddress() && !address.isLinkLocalAddress() && !address.isLoopbackAddress() && !address.isMulticastAddress() && !isUla;
    }

    public void queryNode(int nodeId) {
        GeoIpConfig geoIpConfig = (GeoIpConfig)this.geoIpConfigDao.getContainer().getObject();
        if (!geoIpConfig.isEnabled()) {
            return;
        }
        OnmsNode node = (OnmsNode)this.nodeDao.get((Serializable)Integer.valueOf(nodeId));
        if (node == null) {
            LOG.debug("Failed to return node for given nodeId: {}", (Object)nodeId);
            return;
        }
        OnmsAssetRecord assetRecord = node.getAssetRecord();
        if (assetRecord == null) {
            assetRecord = new OnmsAssetRecord();
            assetRecord.setNode(node);
        }
        OnmsIpInterface primaryInterface = node.getPrimaryInterface();
        InetAddress addressToUse = null;
        if (primaryInterface != null) {
            addressToUse = primaryInterface.getIpAddress();
        } else {
            Optional optionalOnmsIpInterface = node.getIpInterfaces().stream().findFirst();
            if (optionalOnmsIpInterface.isPresent()) {
                addressToUse = ((OnmsIpInterface)optionalOnmsIpInterface.get()).getIpAddress();
            }
        }
        if (!(!GeoIpConfig.Resolve.PUBLIC.equals((Object)geoIpConfig.getResolve()) && !GeoIpConfig.Resolve.PUBLIC_IPV4.equals((Object)geoIpConfig.getResolve()) && !GeoIpConfig.Resolve.PUBLIC_IPV6.equals((Object)geoIpConfig.getResolve()) || addressToUse != null && this.isPublicAddress(addressToUse) && (this.isPublicAddress(addressToUse) && GeoIpConfig.Resolve.PUBLIC_IPV4.equals((Object)geoIpConfig.getResolve()) && addressToUse instanceof Inet4Address || this.isPublicAddress(addressToUse) && GeoIpConfig.Resolve.PUBLIC_IPV6.equals((Object)geoIpConfig.getResolve()) && addressToUse instanceof Inet6Address || this.isPublicAddress(addressToUse) && GeoIpConfig.Resolve.PUBLIC.equals((Object)geoIpConfig.getResolve())))) {
            Set ipInterfaceSet = node.getIpInterfaces();
            for (OnmsIpInterface onmsIpInterface : ipInterfaceSet) {
                if (!this.isPublicAddress(onmsIpInterface.getIpAddress()) || !(GeoIpConfig.Resolve.PUBLIC_IPV4.equals((Object)geoIpConfig.getResolve()) && onmsIpInterface.getIpAddress() instanceof Inet4Address || GeoIpConfig.Resolve.PUBLIC_IPV6.equals((Object)geoIpConfig.getResolve()) && onmsIpInterface.getIpAddress() instanceof Inet6Address) && !GeoIpConfig.Resolve.PUBLIC.equals((Object)geoIpConfig.getResolve())) continue;
                addressToUse = onmsIpInterface.getIpAddress();
                break;
            }
        }
        if (addressToUse != null) {
            Subnet subnet;
            if (assetRecord.getGeolocation() == null) {
                assetRecord.setGeolocation(new OnmsGeolocation());
            }
            if ((subnet = this.getSubnet(geoIpConfig, node.getLocation().getLocationName(), InetAddressUtils.str((InetAddress)addressToUse))) != null) {
                for (Asset asset : subnet.getAssets()) {
                    if ("id".equals(asset.getName()) || "node".equals(asset.getName())) continue;
                    try {
                        if (!geoIpConfig.isOverwrite() && PropertyUtils.getProperty((Object)assetRecord, (String)asset.getName()) != null) continue;
                        try {
                            String clazz;
                            PropertyDescriptor propertyDescriptor = new PropertyDescriptor(asset.getName(), OnmsAssetRecord.class);
                            switch (clazz = propertyDescriptor.getPropertyType().getSimpleName()) {
                                case "String": {
                                    PropertyUtils.setProperty((Object)assetRecord, (String)asset.getName(), (Object)asset.getValue());
                                    LOG.debug("Asset '{}' set to '{}' for node {} with IP address {} (config)...", new Object[]{asset.getName(), asset.getValue(), nodeId, InetAddressUtils.str((InetAddress)addressToUse)});
                                    break;
                                }
                                case "Integer": {
                                    try {
                                        PropertyUtils.setProperty((Object)assetRecord, (String)asset.getName(), (Object)Integer.parseInt(asset.getValue()));
                                        LOG.warn("Asset '{}' set to '{}' for node {} with IP address {} (config)...", new Object[]{asset.getName(), asset.getValue(), nodeId, InetAddressUtils.str((InetAddress)addressToUse)});
                                    }
                                    catch (NumberFormatException e) {
                                        LOG.debug("Error converting value '{}' to Integer...", (Object)asset.getValue(), (Object)e);
                                    }
                                    break;
                                }
                                case "Double": {
                                    try {
                                        PropertyUtils.setProperty((Object)assetRecord, (String)asset.getName(), (Object)Double.parseDouble(asset.getValue()));
                                    }
                                    catch (NumberFormatException e) {
                                        LOG.warn("Error converting value '{}' to Double...", (Object)asset.getValue(), (Object)e);
                                    }
                                    LOG.debug("Asset '{}' set to '{}' for node {} with IP address {} (config)...", new Object[]{asset.getName(), asset.getValue(), nodeId, InetAddressUtils.str((InetAddress)addressToUse)});
                                    break;
                                }
                                default: {
                                    LOG.warn("Value type '{}' not supported", (Object)clazz);
                                    break;
                                }
                            }
                        }
                        catch (IntrospectionException e) {
                            LOG.warn("Error retrieving type class for property '{}'", (Object)asset.getName());
                        }
                    }
                    catch (PropertyException e) {
                        LOG.error("Error setting bean property '{}'", (Object)asset.getName(), (Object)e);
                    }
                }
                this.assetRecordDao.saveOrUpdate((Object)assetRecord);
                this.assetRecordDao.flush();
            } else {
                try {
                    if (!this.isPublicAddress(addressToUse)) {
                        return;
                    }
                    CityResponse cityResponse = this.getDatabaseReader().city(addressToUse);
                    if (geoIpConfig.isOverwrite() || assetRecord.getLongitude() == null) {
                        assetRecord.setLongitude(cityResponse.getLocation().getLongitude());
                        LOG.debug("Asset 'longitude' set to '{}' for node {} with IP address {} (lookup)...", new Object[]{cityResponse.getLocation().getLongitude(), nodeId, InetAddressUtils.str((InetAddress)addressToUse)});
                    }
                    if (geoIpConfig.isOverwrite() || assetRecord.getLatitude() == null) {
                        assetRecord.setLatitude(cityResponse.getLocation().getLatitude());
                        LOG.debug("Asset 'latitude' set to '{}' for node {} with IP address {} (lookup)...", new Object[]{cityResponse.getLocation().getLatitude(), nodeId, InetAddressUtils.str((InetAddress)addressToUse)});
                    }
                    if ((geoIpConfig.isOverwrite() || assetRecord.getCity() == null) && cityResponse.getCity() != null && !Strings.isNullOrEmpty((String)cityResponse.getCity().getName())) {
                        assetRecord.setCity(cityResponse.getCity().getName());
                        LOG.debug("Asset 'city' set to '{}' for node {} with IP address {} (lookup)...", new Object[]{cityResponse.getCity().getName(), nodeId, InetAddressUtils.str((InetAddress)addressToUse)});
                    }
                    if ((geoIpConfig.isOverwrite() || assetRecord.getCountry() == null) && cityResponse.getCountry() != null && !Strings.isNullOrEmpty((String)cityResponse.getCountry().getName())) {
                        assetRecord.setCountry(cityResponse.getCountry().getName());
                        LOG.debug("Asset 'country' set to '{}' for node {} with IP address {} (lookup)...", new Object[]{cityResponse.getCountry().getName(), nodeId, InetAddressUtils.str((InetAddress)addressToUse)});
                    }
                    this.assetRecordDao.saveOrUpdate((Object)assetRecord);
                    this.assetRecordDao.flush();
                }
                catch (IOException e) {
                    LOG.error("Error looking up location for IP address '" + InetAddressUtils.str((InetAddress)addressToUse) + "'", (Throwable)e);
                }
                catch (GeoIp2Exception e) {
                    LOG.warn("No location data found for IP address '" + InetAddressUtils.str((InetAddress)addressToUse) + "'");
                }
            }
        }
    }

    Subnet getSubnet(GeoIpConfig config, String locationName, String addressToUse) {
        IPAddressString ipAddressString = new IPAddressString(addressToUse);
        for (Location location : config.getLocations()) {
            if (!locationName.equals(location.getName())) continue;
            for (Subnet subnet : location.getSubnets()) {
                IPAddressString subnetAddress = new IPAddressString(subnet.getCidr());
                if (!subnetAddress.contains(ipAddressString)) continue;
                return subnet;
            }
        }
        return null;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @EventHandler(uei="uei.opennms.org/internal/reloadDaemonConfig")
    public void handleReloadConfigEvent(IEvent event) {
        if (this.isReloadConfigEventTarget(event)) {
            EventBuilder ebldr = null;
            LOG.debug("Reloading the Hardware Inventory adapter configuration");
            try {
                this.geoIpConfigDao.getContainer().reload();
                this.databaseReader = null;
                ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigSuccessful", "Provisiond.GeoIpProvisioningAdapter");
                ebldr.addParam("daemonName", "Provisiond.GeoIpProvisioningAdapter");
            }
            catch (Throwable e) {
                LOG.warn("Unable to reload Hardware Inventory adapter configuration", e);
                ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigFailed", "Provisiond.GeoIpProvisioningAdapter");
                ebldr.addParam("daemonName", "Provisiond.GeoIpProvisioningAdapter");
                ebldr.addParam("reason", e.getMessage());
            }
            if (ebldr != null) {
                this.getEventForwarder().sendNow(ebldr.getEvent());
            }
        }
    }

    private boolean isReloadConfigEventTarget(IEvent event) {
        boolean isTarget = false;
        for (IParm parm : event.getParmCollection()) {
            if (!"daemonName".equals(parm.getParmName()) || !"Provisiond.GeoIpProvisioningAdapter".equalsIgnoreCase(parm.getValue().getContent())) continue;
            isTarget = true;
            break;
        }
        LOG.debug("isReloadConfigEventTarget: Provisiond. {} was target of reload event: {}", (Object)NAME, (Object)isTarget);
        return isTarget;
    }

    public NodeDao getNodeDao() {
        return this.nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.nodeDao = nodeDao;
    }

    public GeoIpConfigDao getGeoIpConfigDao() {
        return this.geoIpConfigDao;
    }

    public void setGeoIpConfigDao(GeoIpConfigDao geoIpConfigDao) {
        this.geoIpConfigDao = geoIpConfigDao;
    }

    public EventForwarder getEventForwarder() {
        return this.eventForwarder;
    }

    public void setEventForwarder(EventForwarder eventForwarder) {
        this.eventForwarder = eventForwarder;
    }

    public AssetRecordDao getAssetRecordDao() {
        return this.assetRecordDao;
    }

    public void setAssetRecordDao(AssetRecordDao assetRecordDao) {
        this.assetRecordDao = assetRecordDao;
    }

    public void setDatabaseReader(DatabaseReader databaseReader) {
        this.databaseReader = databaseReader;
    }
}

