/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class LazyList<E>
implements List<E> {
    private Loader<E> m_loader;
    private List<E> m_list;
    private boolean m_loaded = false;

    public LazyList(Loader<E> loader) {
        this.m_loader = loader;
    }

    @Override
    public Iterator<E> iterator() {
        this.load();
        return this.m_list.iterator();
    }

    @Override
    public int size() {
        this.load();
        return this.m_list.size();
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        this.load();
        return this.m_list.removeAll(arg0);
    }

    @Override
    public boolean addAll(Collection<? extends E> arg0) {
        this.load();
        return this.m_list.addAll(arg0);
    }

    @Override
    public void clear() {
        this.load();
        this.m_list.clear();
    }

    @Override
    public boolean contains(Object o) {
        this.load();
        return this.m_list.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        this.load();
        return this.m_list.containsAll(arg0);
    }

    @Override
    public boolean isEmpty() {
        this.load();
        return this.m_list.isEmpty();
    }

    @Override
    public boolean remove(Object o) {
        this.load();
        return this.m_list.remove(o);
    }

    @Override
    public Object[] toArray() {
        this.load();
        return this.m_list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] arg0) {
        this.load();
        return this.m_list.toArray(arg0);
    }

    public String toString() {
        this.load();
        return super.toString();
    }

    private void load() {
        if (!this.m_loaded) {
            this.m_list = this.m_loader.load();
            this.m_loaded = true;
        }
    }

    public boolean isLoaded() {
        return this.m_loaded;
    }

    @Override
    public E get(int arg0) {
        this.load();
        return this.m_list.get(arg0);
    }

    @Override
    public boolean add(E o) {
        this.load();
        return this.m_list.add(o);
    }

    @Override
    public void add(int index, E element) {
        this.load();
        this.m_list.add(index, element);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.load();
        return this.m_list.addAll(index, c);
    }

    @Override
    public int indexOf(Object o) {
        this.load();
        return this.m_list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        this.load();
        return this.m_list.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        this.load();
        return this.m_list.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        this.load();
        return this.m_list.listIterator(index);
    }

    @Override
    public E remove(int index) {
        this.load();
        return this.m_list.remove(index);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.load();
        return this.m_list.retainAll(c);
    }

    @Override
    public E set(int index, E element) {
        this.load();
        return this.m_list.set(index, element);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        this.load();
        return this.m_list.subList(fromIndex, toIndex);
    }

    public static interface Loader<E> {
        public List<E> load();
    }
}

