/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.snmp;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.annotation.PreDestroy;
import org.opennms.features.scv.api.SecureCredentialsVault;
import org.opennms.netmgt.config.api.SnmpAgentConfigFactory;
import org.opennms.netmgt.provision.detector.snmp.GenericSnmpDetectorFactory;
import org.opennms.netmgt.provision.detector.snmp.SnmpDetector;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.springframework.stereotype.Component;

@Component
public class SnmpDetectorFactory
extends GenericSnmpDetectorFactory<SnmpDetector> {
    private final ThreadFactory snmpDetectorThreadFactory = new ThreadFactoryBuilder().setNameFormat("snmp-detector-%d").build();
    private final ExecutorService snmpDetectorExecutor = Executors.newCachedThreadPool(this.snmpDetectorThreadFactory);
    private SecureCredentialsVault m_scv;

    public SnmpDetectorFactory() {
        super(SnmpDetector.class);
    }

    public void setSecureCredentialsVault(SecureCredentialsVault scv) {
        this.m_scv = scv;
    }

    @Override
    public SnmpDetector createDetector(Map<String, String> properties) {
        Object snmpDetector = super.createDetector(properties);
        ((SnmpDetector)((Object)snmpDetector)).setSnmpDetectorExecutor(this.snmpDetectorExecutor);
        ((SnmpDetector)((Object)snmpDetector)).setSecureCredentialsVault(this.m_scv);
        return snmpDetector;
    }

    @Override
    public Map<String, String> getRuntimeAttributes(String location, InetAddress address) {
        SnmpAgentConfigFactory agentConfigFactory = this.getAgentConfigFactory();
        if (agentConfigFactory == null) {
            throw new IllegalStateException("Cannot determine agent configuration without a SnmpAgentConfigFactory.");
        }
        List snmpProfiles = agentConfigFactory.getProfiles();
        if (snmpProfiles.isEmpty()) {
            Map map = agentConfigFactory.getAgentConfig(address, location).toMap();
            map.put("location", location);
            return map;
        }
        HashMap<String, String> agentConfigMap = new HashMap<String, String>();
        agentConfigMap.put("hasMultipleAgentConfigs", Boolean.toString(true));
        String defaultConfig = agentConfigFactory.getAgentConfig(address, location).toProtocolConfigString();
        agentConfigMap.put("SNMP_AGENT_CONFIG_default", defaultConfig);
        snmpProfiles.forEach(snmpProfile -> {
            SnmpAgentConfig snmpAgentConfig = agentConfigFactory.getAgentConfigFromProfile(snmpProfile, address);
            agentConfigMap.put("SNMP_AGENT_CONFIG_" + snmpAgentConfig.getProfileLabel(), snmpAgentConfig.toProtocolConfigString());
        });
        agentConfigMap.put("location", location);
        return agentConfigMap;
    }

    @PreDestroy
    public void destroy() {
        this.snmpDetectorExecutor.shutdown();
    }
}

