/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.springframework.security;

import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.authentication.AccountStatusUserDetailsChecker;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsChecker;
import org.springframework.security.kerberos.authentication.KerberosServiceAuthenticationProvider;
import org.springframework.security.kerberos.authentication.KerberosServiceRequestToken;
import org.springframework.security.kerberos.authentication.KerberosTicketValidation;
import org.springframework.security.kerberos.authentication.KerberosTicketValidator;
import org.springframework.security.ldap.search.LdapUserSearch;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;
import org.springframework.util.Assert;

public class KerberosServiceLdapAuthenticationProvider
extends KerberosServiceAuthenticationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(KerberosServiceLdapAuthenticationProvider.class);
    private KerberosTicketValidator m_kerberosTicketValidator;
    private UserDetailsChecker m_userDetailsChecker = new AccountStatusUserDetailsChecker();
    private LdapUserSearch m_ldapUserSearch;
    private LdapAuthoritiesPopulator m_ldapAuthoritiesPopulator;
    private boolean m_trimRealm = true;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        KerberosServiceRequestToken auth = (KerberosServiceRequestToken)authentication;
        byte[] token = auth.getToken();
        LOG.debug("Try to validate Kerberos Token");
        KerberosTicketValidation ticketValidation = this.m_kerberosTicketValidator.validateTicket(token);
        LOG.debug("Succesfully validated " + ticketValidation.username());
        String validatedUsername = this.trimRealmFromUsername(ticketValidation.username());
        DirContextOperations ldapUserEntry = this.m_ldapUserSearch.searchForUser(validatedUsername);
        Collection grantedAuthorities = this.m_ldapAuthoritiesPopulator.getGrantedAuthorities(ldapUserEntry, validatedUsername);
        User userDetails = new User(validatedUsername, "notUsed", true, true, true, true, grantedAuthorities);
        this.m_userDetailsChecker.check((UserDetails)userDetails);
        this.additionalAuthenticationChecks((UserDetails)userDetails, auth);
        KerberosServiceRequestToken responseAuth = new KerberosServiceRequestToken((Object)userDetails, ticketValidation, userDetails.getAuthorities(), token);
        return responseAuth;
    }

    private String trimRealmFromUsername(String username) {
        if (this.m_trimRealm && username.contains("@")) {
            return username.substring(0, username.indexOf("@"));
        }
        return username;
    }

    public void setLdapAuthoritiesPopulator(LdapAuthoritiesPopulator ldapAuthoritiesPopulator) {
        this.m_ldapAuthoritiesPopulator = ldapAuthoritiesPopulator;
    }

    public LdapAuthoritiesPopulator getLdapAuthoritiesPopulator() {
        return this.m_ldapAuthoritiesPopulator;
    }

    public void setLdapUserSearch(LdapUserSearch ldapUserSearch) {
        this.m_ldapUserSearch = ldapUserSearch;
    }

    public LdapUserSearch getLdapUserSearch() {
        return this.m_ldapUserSearch;
    }

    public void setTrimRealm(boolean trimRealm) {
        this.m_trimRealm = trimRealm;
    }

    public boolean getTrimRealm() {
        return this.m_trimRealm;
    }

    public void setTicketValidator(KerberosTicketValidator ticketValidator) {
        this.m_kerberosTicketValidator = ticketValidator;
    }

    public KerberosTicketValidator getTicketValidator() {
        return this.m_kerberosTicketValidator;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_kerberosTicketValidator, (String)"ticketValidator must be set");
        Assert.notNull((Object)this.m_ldapAuthoritiesPopulator, (String)"ldapAuthoritiesPopulator must be set");
    }
}

