/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.jetty;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.resource.Resource;

public class ApproveAbsolutePathAliases
implements ContextHandler.AliasCheck {
    public boolean check(String path, Resource resource) {
        if (path == null || resource == null) {
            return false;
        }
        try {
            File file = resource.getFile();
            if (file == null) {
                return false;
            }
            URI resourceAlias = resource.getAlias();
            if (resourceAlias == null) {
                return false;
            }
            try {
                return new File(resourceAlias).getAbsolutePath().equals(file.getAbsolutePath());
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
    }
}

