/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.util.List;
import org.opennms.core.soa.ServiceRegistry;
import org.opennms.core.soa.lookup.ServiceLookup;
import org.opennms.core.soa.lookup.ServiceLookupBuilder;
import org.opennms.core.soa.lookup.ServiceRegistryLookup;
import org.opennms.core.soa.support.DefaultServiceRegistry;
import org.opennms.netmgt.model.notifd.Argument;
import org.opennms.netmgt.model.notifd.NotificationStrategy;
import org.opennms.netmgt.notifd.ExecutorStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceRegistryExecutor
implements ExecutorStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceRegistryExecutor.class);
    private static final ServiceLookup<Class<?>, String> SERVICE_LOOKUP = new ServiceLookupBuilder((ServiceLookup)new ServiceRegistryLookup((ServiceRegistry)DefaultServiceRegistry.INSTANCE)).blocking().build();

    @Override
    public int execute(String filter, List<Argument> arguments) {
        LOG.debug("Searching for notification strategy matching filter: {}", (Object)filter);
        NotificationStrategy ns = this.getNotificationStrategy(filter);
        if (ns == null) {
            LOG.error("No notification strategy found matching filter: {}", (Object)filter);
            return 1;
        }
        LOG.debug("Found notification strategy: {}", (Object)ns);
        return ns.send(arguments);
    }

    private NotificationStrategy getNotificationStrategy(String filter) {
        return (NotificationStrategy)SERVICE_LOOKUP.lookup(NotificationStrategy.class, (Object)filter);
    }
}

