/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.shell;

import java.net.InetAddress;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.restrictions.AnyRestriction;
import org.opennms.core.criteria.restrictions.EqRestriction;
import org.opennms.core.criteria.restrictions.GeRestriction;
import org.opennms.core.criteria.restrictions.InRestriction;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.dao.api.MonitoringLocationDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.ServiceTypeDao;
import org.opennms.netmgt.dao.api.SessionUtils;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.Event;

@Command(scope="opennms", name="poller-benchmark", description="Benchmark pollerd by creating N nodes/services and waiting for them to be polled.")
@Service
public class Benchmark
implements Action {
    @Reference
    private SessionUtils sessionUtils;
    @Reference
    private MonitoringLocationDao monitoringLocationDao;
    @Reference
    private NodeDao nodeDao;
    @Reference
    private IpInterfaceDao ipInterfaceDao;
    @Reference
    private IpInterfaceDao ipIfaceDao;
    @Reference
    private MonitoredServiceDao monitoredServiceDao;
    @Reference
    private ServiceTypeDao serviceTypeDao;
    @Reference
    private EventForwarder eventForwarder;
    private final int batchSize = 100;
    @Option(name="-n", aliases={"--nodes"}, description="Number of nodes and services to create. A single service per interface per node is created.")
    int numNodes = 100;
    @Option(name="-r", aliases={"--recycle"}, description="Recycle nodes created by a previous run instead of deleting/recreating them.")
    boolean recycleNetwork = false;
    private final Set<Integer> allMonitoredServiceIds = new HashSet<Integer>();

    public Object execute() {
        long startOfPoll;
        System.out.println(String.valueOf(new Date()) + ": Benchmarking started...");
        if (!this.recycleNetwork) {
            System.out.println(String.valueOf(new Date()) + ": Destroying old network...");
            List<Event> eventsToSend = this.destroyOldNetwork();
            System.out.println(String.valueOf(new Date()) + ": Notifying pollerd of deleted services...");
            for (Event e : eventsToSend) {
                this.eventForwarder.sendNow(e);
            }
            System.out.println(String.valueOf(new Date()) + ": Building new network...");
            eventsToSend = this.buildNewNetwork();
            System.out.println(String.valueOf(new Date()) + ": Notifying pollerd of new services...");
            startOfPoll = System.currentTimeMillis();
            for (Event e : eventsToSend) {
                this.eventForwarder.sendNow(e);
            }
        } else {
            System.out.println(String.valueOf(new Date()) + ": Recycling network from previous run...");
            this.recycleNetwork();
            this.numNodes = this.allMonitoredServiceIds.size();
            System.out.printf("%s: Tracking %d services\n", new Date(), this.numNodes);
            startOfPoll = System.currentTimeMillis();
        }
        System.out.println(String.valueOf(new Date()) + ": Waiting for services to be polled...");
        this.waitForServices(startOfPoll);
        long endOfPoll = System.currentTimeMillis();
        System.out.println(String.valueOf(new Date()) + ": Benchmarking done.");
        System.out.println(String.valueOf(new Date()) + ": Services polled in: " + Benchmark.getDurationBreakdown(endOfPoll - startOfPoll));
        return null;
    }

    private void waitForServices(long startOfPoll) {
        Date lastPollLimit = new Date(startOfPoll);
        long totalNumServices = this.allMonitoredServiceIds.size();
        while (true) {
            long numServicesMatching;
            if ((numServicesMatching = (long)((Integer)this.sessionUtils.withTransaction(() -> {
                Criteria criteria = this.criteriaForBenchmarkServices();
                criteria.addRestriction((Restriction)new AnyRestriction(new Restriction[]{new GeRestriction("lastGood", (Object)lastPollLimit), new GeRestriction("lastFail", (Object)lastPollLimit)}));
                return this.monitoredServiceDao.countMatching(criteria);
            })).intValue()) >= totalNumServices) {
                System.out.printf("All %d services have been polled.\n", totalNumServices);
                break;
            }
            System.out.printf("Still waiting for %d (out of %d) services...\n", totalNumServices - numServicesMatching, totalNumServices);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                System.out.println("Interrupted. Aborting.");
                Thread.interrupted();
                break;
            }
        }
    }

    private Criteria criteriaForBenchmarkServices() {
        Criteria criteria = new Criteria(OnmsMonitoredService.class);
        criteria.addRestriction((Restriction)new InRestriction("status", Arrays.asList("A", "N")));
        criteria.setAliases(Arrays.asList(new Alias("ipInterface", "ipInterface", Alias.JoinType.LEFT_JOIN), new Alias("ipInterface.node", "node", Alias.JoinType.LEFT_JOIN)));
        criteria.addRestriction((Restriction)new EqRestriction("node.operatingSystem", (Object)Benchmark.class.getCanonicalName()));
        return criteria;
    }

    private void recycleNetwork() {
        this.sessionUtils.withTransaction(() -> {
            Criteria criteria = this.criteriaForBenchmarkServices();
            for (OnmsMonitoredService svc : this.monitoredServiceDao.findMatching(criteria)) {
                this.allMonitoredServiceIds.add(svc.getId());
            }
        });
    }

    private List<Event> destroyOldNetwork() {
        LinkedList<Event> eventsToSend = new LinkedList<Event>();
        AtomicBoolean nodesRemaining = new AtomicBoolean(true);
        while (nodesRemaining.get()) {
            this.sessionUtils.withTransaction(() -> {
                Criteria criteria = new Criteria(OnmsNode.class);
                criteria.addRestriction((Restriction)new EqRestriction("operatingSystem", (Object)Benchmark.class.getCanonicalName()));
                criteria.setLimit(Integer.valueOf(100));
                List nodes = this.nodeDao.findMatching(criteria);
                nodes.forEach(node -> {
                    this.nodeDao.delete(node);
                    EventBuilder eventBuilder = new EventBuilder("uei.opennms.org/nodes/nodeDeleted", Benchmark.class.getCanonicalName()).setNode(node);
                    eventBuilder.addParam("nodelabel", node.getLabel());
                    eventsToSend.add(eventBuilder.getEvent());
                });
                nodesRemaining.set(!nodes.isEmpty());
            });
        }
        return eventsToSend;
    }

    private List<Event> buildNewNetwork() {
        LinkedList<Event> eventsToSend = new LinkedList<Event>();
        InetAddress loopbackAddress = InetAddressUtils.addr((String)"127.0.0.1");
        OnmsServiceType icmpServiceType = this.serviceTypeDao.findByName("ICMP");
        for (int i = 0; i < this.numNodes; ++i) {
            int k = i;
            this.sessionUtils.withTransaction(() -> {
                OnmsNode node = new OnmsNode();
                node.setLabel("bench-n" + k);
                node.setLocation(this.monitoringLocationDao.getDefaultLocation());
                node.setOperatingSystem(Benchmark.class.getCanonicalName());
                this.nodeDao.saveOrUpdate((Object)node);
                OnmsIpInterface iface = new OnmsIpInterface();
                iface.setNode(node);
                iface.setIpAddress(loopbackAddress);
                node.addIpInterface(iface);
                this.ipIfaceDao.saveOrUpdate((Object)iface);
                OnmsMonitoredService svcICMP = new OnmsMonitoredService();
                svcICMP.setIpInterface(iface);
                svcICMP.setServiceType(icmpServiceType);
                svcICMP.setStatus("A");
                iface.addMonitoredService(svcICMP);
                this.monitoredServiceDao.saveOrUpdate((Object)svcICMP);
                this.allMonitoredServiceIds.add(svcICMP.getId());
                EventBuilder eventBuilder = new EventBuilder("uei.opennms.org/nodes/nodeGainedService", "benchmark").setNode(node).setInterface(iface.getIpAddress()).setService(svcICMP.getServiceName());
                eventBuilder.addParam("nodelabel", node.getLabel());
                eventsToSend.add(eventBuilder.getEvent());
            });
            if ((i + 1) % 100 != 0) continue;
            System.out.printf("Created %d/%d nodes\n", i + 1, this.numNodes);
        }
        return eventsToSend;
    }

    public static String getDurationBreakdown(long millis) {
        if (millis < 0L) {
            throw new IllegalArgumentException("Duration must be greater than zero!");
        }
        long days = TimeUnit.MILLISECONDS.toDays(millis);
        long hours = TimeUnit.MILLISECONDS.toHours(millis -= TimeUnit.DAYS.toMillis(days));
        long minutes = TimeUnit.MILLISECONDS.toMinutes(millis -= TimeUnit.HOURS.toMillis(hours));
        long seconds = TimeUnit.MILLISECONDS.toSeconds(millis -= TimeUnit.MINUTES.toMillis(minutes));
        StringBuilder sb = new StringBuilder(64);
        sb.append(days);
        sb.append(" Days ");
        sb.append(hours);
        sb.append(" Hours ");
        sb.append(minutes);
        sb.append(" Minutes ");
        sb.append(seconds);
        sb.append(" Seconds");
        return sb.toString();
    }
}

