/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.jaxb.callback;

import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.json.JSONObject;
import org.opennms.features.config.exception.ConfigConversionException;
import org.opennms.features.config.exception.ValidationException;
import org.opennms.features.config.service.api.ConfigUpdateInfo;
import org.opennms.features.config.service.util.ConfigConvertUtil;
import org.opennms.netmgt.config.provisiond.ProvisiondConfiguration;
import org.opennms.netmgt.config.provisiond.RequisitionDef;
import org.quartz.CronExpression;

public class ProvisiondConfigurationValidationCallback
implements Consumer<ConfigUpdateInfo> {
    @Override
    public void accept(ConfigUpdateInfo configUpdateInfo) {
        JSONObject json = configUpdateInfo.getConfigJson();
        if (json == null) {
            throw new ValidationException(String.format("%s config is empty.", configUpdateInfo.getConfigName()));
        }
        try {
            ProvisiondConfiguration provisiondConfiguration = (ProvisiondConfiguration)ConfigConvertUtil.jsonToObject((String)json.toString(), ProvisiondConfiguration.class);
            ProvisiondConfigurationValidationCallback.validateCron(provisiondConfiguration);
            ProvisiondConfigurationValidationCallback.checkNames(provisiondConfiguration.getRequisitionDefs());
        }
        catch (ConfigConversionException e) {
            throw new ValidationException(e.getMessage());
        }
    }

    private static void validateCron(ProvisiondConfiguration provisiondConfiguration) {
        for (RequisitionDef r : provisiondConfiguration.getRequisitionDefs()) {
            r.getCronSchedule().ifPresent(exp -> {
                if (!CronExpression.isValidExpression((String)exp)) {
                    throw new ValidationException(String.format("Invalid cron expression. %s", exp));
                }
            });
        }
    }

    private static void checkNames(List<RequisitionDef> requisitionDefs) {
        Set uniqueNames;
        if (requisitionDefs != null && (uniqueNames = requisitionDefs.stream().map(requisitionDef -> requisitionDef.getImportName().orElse(null)).filter(name -> name != null && !name.isBlank()).collect(Collectors.toSet())).size() != requisitionDefs.size()) {
            throw new ValidationException(String.format("All requisition definitions must have unique names", new Object[0]));
        }
    }
}

