/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.jaxb;

import java.util.Collections;
import java.util.List;
import org.opennms.core.xml.AbstractJaxbConfigDao;
import org.opennms.netmgt.config.reporting.DateParm;
import org.opennms.netmgt.config.reporting.IntParm;
import org.opennms.netmgt.config.reporting.OpennmsReports;
import org.opennms.netmgt.config.reporting.Parameters;
import org.opennms.netmgt.config.reporting.Report;
import org.opennms.netmgt.config.reporting.StringParm;
import org.opennms.netmgt.dao.api.OnmsReportConfigDao;

public class DefaultOnmsReportConfigDao
extends AbstractJaxbConfigDao<OpennmsReports, List<Report>>
implements OnmsReportConfigDao {
    public DefaultOnmsReportConfigDao() {
        super(OpennmsReports.class, "OpenNMS Report Configuration");
    }

    public String getHtmlStylesheetLocation(String id) {
        Report report = this.getReport(id);
        if (report != null) {
            return report.getHtmlTemplate().orElse(null);
        }
        return null;
    }

    public String getPdfStylesheetLocation(String id) {
        Report report = this.getReport(id);
        if (report != null) {
            return report.getPdfTemplate().orElse(null);
        }
        return null;
    }

    public String getSvgStylesheetLocation(String id) {
        Report report = this.getReport(id);
        if (report != null) {
            return report.getSvgTemplate().orElse(null);
        }
        return null;
    }

    public String getLogo(String id) {
        Report report = this.getReport(id);
        if (report != null) {
            return report.getLogo();
        }
        return null;
    }

    public String getType(String id) {
        Report report = this.getReport(id);
        if (report != null) {
            return report.getType();
        }
        return null;
    }

    private Report getReport(String id) {
        for (Report report : (List)this.getContainer().getObject()) {
            if (!id.equals(report.getId())) continue;
            return report;
        }
        return null;
    }

    public Parameters getParameters(String id) {
        Report report = this.getReport(id);
        if (report != null) {
            return report.getParameters().orElse(null);
        }
        return null;
    }

    public List<DateParm> getDateParms(String id) {
        Report report = this.getReport(id);
        if (report != null && report.getParameters().isPresent()) {
            return ((Parameters)report.getParameters().get()).getDateParms();
        }
        return null;
    }

    public List<StringParm> getStringParms(String id) {
        Report report = this.getReport(id);
        if (report != null && report.getParameters().isPresent()) {
            return ((Parameters)report.getParameters().get()).getStringParms();
        }
        return null;
    }

    public List<IntParm> getIntParms(String id) {
        Report report = this.getReport(id);
        if (report != null && report.getParameters().isPresent()) {
            return ((Parameters)report.getParameters().get()).getIntParms();
        }
        return null;
    }

    public List<Report> translateConfig(OpennmsReports config) {
        return Collections.unmodifiableList(config.getReports());
    }
}

