/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.jaxb;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ListIterator;
import org.apache.commons.io.IOUtils;
import org.opennms.core.xml.AbstractJaxbConfigDao;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.microblog.MicroblogConfiguration;
import org.opennms.netmgt.config.microblog.MicroblogProfile;
import org.opennms.netmgt.dao.api.MicroblogConfigurationDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessResourceFailureException;

public class DefaultMicroblogConfigurationDao
extends AbstractJaxbConfigDao<MicroblogConfiguration, MicroblogConfiguration>
implements MicroblogConfigurationDao {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultMicroblogConfigurationDao.class);

    public DefaultMicroblogConfigurationDao() {
        super(MicroblogConfiguration.class, "Microblog Configuration");
    }

    public MicroblogConfiguration getConfig() {
        return (MicroblogConfiguration)this.getContainer().getObject();
    }

    public MicroblogConfiguration translateConfig(MicroblogConfiguration config) {
        return config;
    }

    public void reloadConfiguration() throws DataAccessResourceFailureException {
        this.getContainer().reload();
    }

    public MicroblogProfile getDefaultProfile() {
        String defaultProfileName = ((MicroblogConfiguration)this.getContainer().getObject()).getDefaultMicroblogProfileName();
        LOG.debug("Requesting default microblog, which is called '{}'", (Object)defaultProfileName);
        return this.getProfile(defaultProfileName);
    }

    public MicroblogProfile getProfile(String name) {
        if (name == null) {
            return null;
        }
        for (MicroblogProfile profile : ((MicroblogConfiguration)this.getContainer().getObject()).getMicroblogProfiles()) {
            if (!name.equals(profile.getName())) continue;
            return profile;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveProfile(MicroblogProfile profile) throws IOException {
        File file;
        this.reloadConfiguration();
        MicroblogConfiguration config = (MicroblogConfiguration)this.getContainer().getObject();
        boolean found = false;
        ListIterator<MicroblogProfile> it = config.getMicroblogProfiles().listIterator();
        while (it.hasNext()) {
            MicroblogProfile existing = (MicroblogProfile)it.next();
            if (!existing.getName().equals(profile.getName())) continue;
            found = true;
            it.set(profile);
            break;
        }
        if (!found) {
            config.addMicroblogProfile(profile);
        }
        if ((file = this.getContainer().getFile()) == null) {
            LOG.warn("No file associated with this config.  Skipping marshal.");
            return;
        }
        FileWriter writer = null;
        try {
            writer = new FileWriter(file);
            JaxbUtils.marshal((Object)config, (Writer)writer);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(writer);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)writer);
    }
}

