/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Query;
import org.hibernate.classic.Session;
import org.opennms.netmgt.dao.api.EventConfEventDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.model.EventConfEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventConfEventDaoHibernate
extends AbstractDaoHibernate<EventConfEvent, Long>
implements EventConfEventDao {
    private static final Logger LOG = LoggerFactory.getLogger(EventConfEventDaoHibernate.class);

    public EventConfEventDaoHibernate() {
        super(EventConfEvent.class);
    }

    public List<EventConfEvent> findBySourceId(Long sourceId) {
        return this.find("from EventConfEvent e where e.source.id = ? order by e.createdTime desc", sourceId);
    }

    public EventConfEvent findByUei(String uei) {
        List list = this.find("from EventConfEvent e where e.uei = ?", uei);
        return list.isEmpty() ? null : (EventConfEvent)list.get(0);
    }

    public List<EventConfEvent> findByUeiAndSourceId(String uei, Long sourceId) {
        return this.find("from EventConfEvent e where e.uei = ? and e.source.id = ?", uei, sourceId);
    }

    public int countBySourceId(Long sourceId) {
        return this.queryInt("select count(e.id) from EventConfEvent e where e.source.id = ?", sourceId);
    }

    public List<EventConfEvent> filterEventConf(String uei, String vendor, String sourceName, int offset, int limit) {
        ArrayList<CallSite> queryParamList = new ArrayList<CallSite>();
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append("from EventConfEvent e where 1=1 ");
        if (uei != null && !uei.trim().isEmpty()) {
            queryBuilder.append(" and lower(e.uei) like ? escape '\\' ");
            queryParamList.add((CallSite)((Object)("%" + this.escapeLike(uei.trim().toLowerCase()) + "%")));
        }
        if (vendor != null && !vendor.trim().isEmpty()) {
            queryBuilder.append(" and lower(e.source.vendor) like ? escape '\\' ");
            queryParamList.add((CallSite)((Object)("%" + this.escapeLike(vendor.trim().toLowerCase()) + "%")));
        }
        if (sourceName != null && !sourceName.trim().isEmpty()) {
            queryBuilder.append(" and lower(e.source.name) like ? escape '\\' ");
            queryParamList.add((CallSite)((Object)("%" + this.escapeLike(sourceName.trim().toLowerCase()) + "%")));
        }
        queryBuilder.append(" order by e.createdTime desc ");
        return this.findWithPagination(queryBuilder.toString(), queryParamList.toArray(), offset, limit);
    }

    public Map<String, Object> findBySourceId(Long sourceId, String eventFilter, String eventSortBy, String eventOrder, Integer totalRecords, Integer offset, Integer limit) {
        int resultCount = totalRecords != null ? totalRecords : 0;
        ArrayList<Object> queryParams = new ArrayList<Object>();
        ArrayList<String> conditions = new ArrayList<String>();
        Object whereClause = "where e.source.id = ? ";
        queryParams.add(sourceId);
        if (eventFilter != null && !eventFilter.trim().isEmpty()) {
            String escapedFilter = "%" + this.escapeLike(eventFilter.trim().toLowerCase()) + "%";
            conditions.add("lower(e.uei) like ? escape '\\'");
            queryParams.add(escapedFilter);
            conditions.add("lower(e.eventLabel) like ? escape '\\'");
            queryParams.add(escapedFilter);
            conditions.add("lower(e.description) like ? escape '\\'");
            queryParams.add(escapedFilter);
        }
        whereClause = (String)whereClause + (String)(conditions.isEmpty() ? "" : " AND ( " + String.join((CharSequence)" OR ", conditions) + ")");
        if (resultCount == 0) {
            String countQuery = "select count(e.id) from EventConfEvent e " + (String)whereClause;
            resultCount = super.queryInt(countQuery, queryParams.toArray());
        }
        List eventConfEventList = Collections.emptyList();
        if (resultCount > 0) {
            Object orderBy = "";
            String sortField = eventSortBy;
            String sortOrder = "ASC".equalsIgnoreCase(eventOrder) ? "ASC" : "DESC";
            Set<String> allowedSortFields = Set.of("uei", "eventLabel", "description", "severity", "enabled");
            if (eventSortBy == null || !allowedSortFields.contains(eventSortBy)) {
                sortField = "createdTime";
            }
            orderBy = "severity".equalsIgnoreCase(sortField) ? " order by case upper(e.severity)  when 'INDETERMINATE' then 1  when 'CLEARED' then 2  when 'NORMAL' then 3  when 'WARNING' then 4  when 'MINOR' then 5  when 'MAJOR' then 6  when 'CRITICAL' then 7  else 999 end " + sortOrder : " order by e." + sortField + " " + sortOrder;
            String dataQuery = "from EventConfEvent e " + (String)whereClause + (String)orderBy;
            eventConfEventList = this.findWithPagination(dataQuery, queryParams.toArray(), offset, limit);
        }
        return Map.of("totalRecords", resultCount, "eventConfEventList", eventConfEventList);
    }

    public void saveAll(Collection<EventConfEvent> events) {
        if (events == null || events.isEmpty()) {
            return;
        }
        int batchSize = 50;
        int i = 0;
        for (EventConfEvent event : events) {
            this.getHibernateTemplate().saveOrUpdate((Object)event);
            if (++i % batchSize != 0) continue;
            this.getHibernateTemplate().flush();
            this.getHibernateTemplate().clear();
        }
        this.getHibernateTemplate().flush();
        this.getHibernateTemplate().clear();
    }

    private String escapeLike(String input) {
        return input.replace("\\", "\\\\").replace("%", "\\%").replace("_", "\\_").replace("@", "\\@").replace("/", "\\/").replace("[", "\\[").replace("]", "\\]").replace(".", "\\.");
    }

    public List<EventConfEvent> findEnabledEvents() {
        return this.find("from EventConfEvent e where e.enabled = true order by e.id asc");
    }

    public void deleteBySourceId(Long sourceId) {
        this.getHibernateTemplate().bulkUpdate("delete from EventConfEvent e where e.source.id = ?", (Object)sourceId);
    }

    @Override
    public void deleteAll(Collection<EventConfEvent> list) {
        super.deleteAll(list);
    }

    public void updateEventEnabledFlag(Long sourceId, List<Long> eventIds, boolean enabled) {
        if (eventIds == null || eventIds.isEmpty()) {
            LOG.warn("No event IDs provided for update. Skipping...");
            return;
        }
        Session session = this.getSessionFactory().getCurrentSession();
        String hql = "update EventConfEvent e set e.enabled = :enabled where e.source.id = :sourceId and e.id in (:eventIds)";
        Query query = session.createQuery(hql);
        query.setParameter("enabled", (Object)enabled);
        query.setParameter("sourceId", (Object)sourceId);
        query.setParameterList("eventIds", eventIds);
        int updatedCount = query.executeUpdate();
        LOG.info("Updated {} events (enabled={}) for sourceId={}", new Object[]{updatedCount, enabled, sourceId});
    }

    public void deleteByEventIds(Long sourceId, List<Long> eventIds) {
        int deletedCount = (Integer)this.getHibernateTemplate().execute(session -> session.createQuery("delete from EventConfEvent e where e.source.id = :sourceId and  e.id in (:ids)").setParameter("sourceId", (Object)sourceId).setParameterList("ids", (Collection)eventIds).executeUpdate());
        LOG.info("Deleted {} EventConfEvent(s) with IDs: {} for sourceId: {}", new Object[]{deletedCount, eventIds, sourceId});
    }

    public List<EventConfEvent> findEventsByVendor(String vendor) {
        return this.find("from EventConfEvent e where e.enabled = true  and  e.source.vendor = ? order by e.id asc ", vendor);
    }

    public EventConfEvent findBySourceIdAndEventId(Long sourceId, Long eventId) {
        return (EventConfEvent)this.findUnique("from EventConfEvent e where e.source.id = ? AND  e.id = ? ", sourceId, eventId);
    }
}

