/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import com.google.common.collect.Lists;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.dao.api.ApplicationDao;
import org.opennms.netmgt.dao.api.ApplicationStatus;
import org.opennms.netmgt.dao.api.MonitoredServiceStatusEntity;
import org.opennms.netmgt.dao.api.ServicePerspective;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.dao.util.ReductionKeyHelper;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsApplication;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.model.monitoringLocations.OnmsMonitoringLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate3.HibernateCallback;

public class ApplicationDaoHibernate
extends AbstractDaoHibernate<OnmsApplication, Integer>
implements ApplicationDao {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationDaoHibernate.class);

    public ApplicationDaoHibernate() {
        super(OnmsApplication.class);
    }

    public OnmsApplication findByName(String name) {
        return (OnmsApplication)this.findUnique("from OnmsApplication as app where app.name = ?", name);
    }

    public List<ApplicationStatus> getApplicationStatus() {
        return this.getApplicationStatus(this.findAll());
    }

    public List<ApplicationStatus> getApplicationStatus(List<OnmsApplication> applications) {
        ArrayList<ApplicationStatus> statusList = new ArrayList<ApplicationStatus>();
        for (OnmsApplication application : applications) {
            HashSet reductionKeys = new HashSet();
            for (OnmsMonitoredService eachService : application.getMonitoredServices()) {
                reductionKeys.addAll(ReductionKeyHelper.getReductionKeys((OnmsMonitoredService)eachService));
            }
            if (!reductionKeys.isEmpty()) {
                CriteriaBuilder builder = new CriteriaBuilder(OnmsAlarm.class);
                builder.in("reductionKey", reductionKeys);
                HibernateCallback callback = this.buildHibernateCallback(builder.toCriteria());
                List alarms = (List)this.getHibernateTemplate().execute(callback);
                Optional maxSeverity = alarms.stream().reduce((leftAlarm, rightAlarm) -> {
                    if (leftAlarm.getSeverity().isGreaterThan(rightAlarm.getSeverity())) {
                        return leftAlarm;
                    }
                    return rightAlarm;
                });
                if (maxSeverity.isPresent()) {
                    statusList.add(new ApplicationStatus(application, ((OnmsAlarm)maxSeverity.get()).getSeverity()));
                    continue;
                }
                statusList.add(new ApplicationStatus(application, OnmsSeverity.NORMAL));
                continue;
            }
            statusList.add(new ApplicationStatus(application, OnmsSeverity.NORMAL));
        }
        return statusList;
    }

    public List<MonitoredServiceStatusEntity> getAlarmStatus() {
        return this.getAlarmStatus(this.findAll());
    }

    public List<MonitoredServiceStatusEntity> getAlarmStatus(List<OnmsApplication> applications) {
        Objects.requireNonNull(applications);
        List services = applications.stream().flatMap(application -> application.getMonitoredServices().stream()).collect(Collectors.toList());
        String sql = "select alarm.node.id, alarm.ipAddr, alarm.serviceType.id, min(alarm.lastEventTime), max(alarm.severity), (count(*) - count(alarm.alarmAckTime)) from OnmsAlarm alarm where alarm.severity != :severity and alarm.reductionKey in :keys group by alarm.node.id, alarm.ipAddr, alarm.serviceType.id";
        Set reductionKeys = services.stream().flatMap(service -> ReductionKeyHelper.getNodeLostServiceFromPerspectiveReductionKeys((OnmsMonitoredService)service).stream()).collect(Collectors.toSet());
        if (services.isEmpty() || reductionKeys.isEmpty()) {
            return Lists.newArrayList();
        }
        List perspectiveAlarmsForService = this.getHibernateTemplate().findByNamedParam("select alarm.node.id, alarm.ipAddr, alarm.serviceType.id, min(alarm.lastEventTime), max(alarm.severity), (count(*) - count(alarm.alarmAckTime)) from OnmsAlarm alarm where alarm.severity != :severity and alarm.reductionKey in :keys group by alarm.node.id, alarm.ipAddr, alarm.serviceType.id", new String[]{"keys", "severity"}, new Object[]{reductionKeys.toArray(), OnmsSeverity.CLEARED});
        ArrayList<MonitoredServiceStatusEntity> entityList = new ArrayList<MonitoredServiceStatusEntity>();
        for (Object[] eachRow : perspectiveAlarmsForService) {
            MonitoredServiceStatusEntity entity = new MonitoredServiceStatusEntity(((Integer)eachRow[0]).intValue(), (InetAddress)eachRow[1], ((Integer)eachRow[2]).intValue(), (Date)eachRow[3], (OnmsSeverity)eachRow[4], ((Long)eachRow[5]).longValue());
            entityList.add(entity);
        }
        return entityList;
    }

    public List<OnmsMonitoringLocation> getPerspectiveLocationsForService(int nodeId, InetAddress ipAddress, String serviceName) {
        return this.getHibernateTemplate().find("select distinct perspectiveLocation from OnmsMonitoredService service join service.applications application join application.perspectiveLocations perspectiveLocation where service.ipInterface.node.id = ? and       service.ipInterface.ipAddress = ? and       service.serviceType.name = ?", new Object[]{nodeId, ipAddress, serviceName});
    }

    public List<ServicePerspective> getServicePerspectives() {
        return this.findObjects(ServicePerspective.class, "select distinct new org.opennms.netmgt.dao.api.ServicePerspective(service, perspectiveLocation) from OnmsApplication as application inner join application.monitoredServices as service inner join application.perspectiveLocations as perspectiveLocation", new Object[0]);
    }
}

