/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.icmp;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.Callable;
import org.opennms.netmgt.icmp.Pinger;
import org.opennms.netmgt.icmp.PingerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPingerFactory
implements PingerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPingerFactory.class);
    protected static final Cache<Integer, Pinger> m_pingers = CacheBuilder.newBuilder().build();

    public abstract Class<? extends Pinger> getPingerClass();

    @Override
    public Pinger getInstance() {
        return this.getInstance(0, true);
    }

    @Override
    public Pinger getInstance(final int tc, boolean allowFragmentation) {
        Class<? extends Pinger> clazz;
        int isFrag = allowFragmentation ? 2 : 1;
        try {
            clazz = this.getPingerClass();
        }
        catch (RuntimeException e) {
            IllegalArgumentException ex = new IllegalArgumentException("Unable to find class named " + System.getProperty("org.opennms.netmgt.icmp.pingerClass", "org.opennms.netmgt.icmp.jni6.Jni6Pinger"), e);
            LOG.error(ex.getLocalizedMessage(), (Throwable)ex);
            throw ex;
        }
        try {
            return (Pinger)m_pingers.get((Object)((tc + 1) * isFrag), (Callable)new Callable<Pinger>(){

                @Override
                public Pinger call() throws Exception {
                    Pinger pinger = (Pinger)clazz.newInstance();
                    pinger.setTrafficClass(tc);
                    return pinger;
                }
            });
        }
        catch (Throwable e) {
            IllegalArgumentException ex = e.getCause() instanceof InstantiationException ? new IllegalArgumentException("Error trying to create pinger of type " + String.valueOf(clazz), e.getCause()) : (e.getCause() instanceof IllegalAccessException ? new IllegalArgumentException("Unable to create pinger of type " + String.valueOf(clazz) + ".  It does not appear to have a public constructor", e) : new IllegalArgumentException("Unexpected exception thrown while trying to create pinger of type " + String.valueOf(clazz), e));
            LOG.error(ex.getLocalizedMessage(), (Throwable)ex);
            throw ex;
        }
    }

    public void setInstance(int tc, boolean allowFragmentation, Pinger pinger) {
        int isFrag = allowFragmentation ? 2 : 1;
        m_pingers.put((Object)((tc + 1) * isFrag), (Object)pinger);
    }

    public void reset() {
        m_pingers.invalidateAll();
        m_pingers.cleanUp();
    }
}

