/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rt;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opennms.netmgt.rt.CustomFieldValue;

public class CustomField
implements Serializable {
    private static final long serialVersionUID = 4640559401699963154L;
    private String m_name;
    private List<CustomFieldValue> m_values;

    public CustomField() {
        this(null, new ArrayList<CustomFieldValue>());
    }

    public CustomField(String name) {
        this(name, new ArrayList<CustomFieldValue>());
    }

    public CustomField(String name, String value, boolean csv) {
        this(name);
        if (csv && value != null) {
            for (String aValue : value.split(",")) {
                this.m_values.add(new CustomFieldValue(aValue));
            }
        } else {
            this.m_values.add(new CustomFieldValue(value));
        }
    }

    public CustomField(String name, List<CustomFieldValue> values) {
        this.m_name = name;
        this.m_values = values;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public List<CustomFieldValue> getValues() {
        return this.m_values;
    }

    public void setValues(List<CustomFieldValue> values) {
        this.m_values = values;
    }

    public void addValue(CustomFieldValue value) {
        this.m_values.add(value);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("Name", (Object)this.m_name).append("Value count", this.m_values.size()).append("Values", (Object)StringUtils.join(this.m_values, (String)", ")).toString();
    }
}

